package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class SearchSchemaSummary(
    registryName: Option[__string] = None,
    schemaArn: Option[__string] = None,
    schemaName: Option[__string] = None,
    schemaVersions: Option[
      Iterable[zio.aws.schemas.model.SearchSchemaVersionSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.SearchSchemaSummary = {
    import SearchSchemaSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.SearchSchemaSummary
      .builder()
      .optionallyWith(
        registryName.map(value => __string.unwrap(value): java.lang.String)
      )(_.registryName)
      .optionallyWith(
        schemaArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .optionallyWith(
        schemaName.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaName)
      .optionallyWith(
        schemaVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schemaVersions)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.SearchSchemaSummary.ReadOnly =
    zio.aws.schemas.model.SearchSchemaSummary.wrap(buildAwsValue())
}
object SearchSchemaSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.SearchSchemaSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.SearchSchemaSummary =
      zio.aws.schemas.model.SearchSchemaSummary(
        registryName.map(value => value),
        schemaArn.map(value => value),
        schemaName.map(value => value),
        schemaVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def registryName: Option[__string]
    def schemaArn: Option[__string]
    def schemaName: Option[__string]
    def schemaVersions: Option[
      List[zio.aws.schemas.model.SearchSchemaVersionSummary.ReadOnly]
    ]
    def getRegistryName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryName", registryName)
    def getSchemaArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getSchemaName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getSchemaVersions: ZIO[Any, AwsError, List[
      zio.aws.schemas.model.SearchSchemaVersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("schemaVersions", schemaVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.SearchSchemaSummary
  ) extends zio.aws.schemas.model.SearchSchemaSummary.ReadOnly {
    override val registryName: Option[__string] = scala
      .Option(impl.registryName())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val schemaArn: Option[__string] = scala
      .Option(impl.schemaArn())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val schemaName: Option[__string] = scala
      .Option(impl.schemaName())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val schemaVersions: Option[
      List[zio.aws.schemas.model.SearchSchemaVersionSummary.ReadOnly]
    ] = scala
      .Option(impl.schemaVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.schemas.model.SearchSchemaVersionSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.SearchSchemaSummary
  ): zio.aws.schemas.model.SearchSchemaSummary.ReadOnly = new Wrapper(impl)
}
