package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class PutCodeBindingRequest(
    language: __string,
    registryName: __string,
    schemaName: __string,
    schemaVersion: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest = {
    import PutCodeBindingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest
      .builder()
      .language(__string.unwrap(language): java.lang.String)
      .registryName(__string.unwrap(registryName): java.lang.String)
      .schemaName(__string.unwrap(schemaName): java.lang.String)
      .optionallyWith(
        schemaVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaVersion)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.PutCodeBindingRequest.ReadOnly =
    zio.aws.schemas.model.PutCodeBindingRequest.wrap(buildAwsValue())
}
object PutCodeBindingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.PutCodeBindingRequest =
      zio.aws.schemas.model.PutCodeBindingRequest(
        language,
        registryName,
        schemaName,
        schemaVersion.map(value => value)
      )
    def language: __string
    def registryName: __string
    def schemaName: __string
    def schemaVersion: Option[__string]
    def getLanguage: ZIO[Any, Nothing, __string] = ZIO.succeed(language)
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaName: ZIO[Any, Nothing, __string] = ZIO.succeed(schemaName)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest
  ) extends zio.aws.schemas.model.PutCodeBindingRequest.ReadOnly {
    override val language: __string =
      zio.aws.schemas.model.primitives.__string(impl.language())
    override val registryName: __string =
      zio.aws.schemas.model.primitives.__string(impl.registryName())
    override val schemaName: __string =
      zio.aws.schemas.model.primitives.__string(impl.schemaName())
    override val schemaVersion: Option[__string] = scala
      .Option(impl.schemaVersion())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest
  ): zio.aws.schemas.model.PutCodeBindingRequest.ReadOnly = new Wrapper(impl)
}
