package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.{
  __string,
  __boolean,
  __stringMin20Max1600,
  __stringMin0Max256
}
import scala.jdk.CollectionConverters._
final case class CreateDiscovererRequest(
    description: Option[__stringMin0Max256] = None,
    sourceArn: __stringMin20Max1600,
    crossAccount: Option[__boolean] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.CreateDiscovererRequest = {
    import CreateDiscovererRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.CreateDiscovererRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          __stringMin0Max256.unwrap(value): java.lang.String
        )
      )(_.description)
      .sourceArn(__stringMin20Max1600.unwrap(sourceArn): java.lang.String)
      .optionallyWith(
        crossAccount.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.crossAccount)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.CreateDiscovererRequest.ReadOnly =
    zio.aws.schemas.model.CreateDiscovererRequest.wrap(buildAwsValue())
}
object CreateDiscovererRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.CreateDiscovererRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.CreateDiscovererRequest =
      zio.aws.schemas.model.CreateDiscovererRequest(
        description.map(value => value),
        sourceArn,
        crossAccount.map(value => value),
        tags.map(value => value)
      )
    def description: Option[__stringMin0Max256]
    def sourceArn: __stringMin20Max1600
    def crossAccount: Option[__boolean]
    def tags: Option[Map[__string, __string]]
    def getDescription: ZIO[Any, AwsError, __stringMin0Max256] =
      AwsError.unwrapOptionField("description", description)
    def getSourceArn: ZIO[Any, Nothing, __stringMin20Max1600] =
      ZIO.succeed(sourceArn)
    def getCrossAccount: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("crossAccount", crossAccount)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.CreateDiscovererRequest
  ) extends zio.aws.schemas.model.CreateDiscovererRequest.ReadOnly {
    override val description: Option[__stringMin0Max256] = scala
      .Option(impl.description())
      .map(value => zio.aws.schemas.model.primitives.__stringMin0Max256(value))
    override val sourceArn: __stringMin20Max1600 =
      zio.aws.schemas.model.primitives.__stringMin20Max1600(impl.sourceArn())
    override val crossAccount: Option[__boolean] = scala
      .Option(impl.crossAccount())
      .map(value => zio.aws.schemas.model.primitives.__boolean(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.schemas.model.primitives
              .__string(key) -> zio.aws.schemas.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.CreateDiscovererRequest
  ): zio.aws.schemas.model.CreateDiscovererRequest.ReadOnly = new Wrapper(impl)
}
