package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyResponse(
    policy: Option[__string] = None,
    revisionId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.PutResourcePolicyResponse = {
    import PutResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.PutResourcePolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => __string.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(
        revisionId.map(value => __string.unwrap(value): java.lang.String)
      )(_.revisionId)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.PutResourcePolicyResponse.ReadOnly =
    zio.aws.schemas.model.PutResourcePolicyResponse.wrap(buildAwsValue())
}
object PutResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.PutResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.PutResourcePolicyResponse =
      zio.aws.schemas.model.PutResourcePolicyResponse(
        policy.map(value => value),
        revisionId.map(value => value)
      )
    def policy: Option[__string]
    def revisionId: Option[__string]
    def getPolicy: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("policy", policy)
    def getRevisionId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.PutResourcePolicyResponse
  ) extends zio.aws.schemas.model.PutResourcePolicyResponse.ReadOnly {
    override val policy: Option[__string] = scala
      .Option(impl.policy())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val revisionId: Option[__string] = scala
      .Option(impl.revisionId())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.PutResourcePolicyResponse
  ): zio.aws.schemas.model.PutResourcePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
