package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DescribeCodeBindingRequest(
    language: __string,
    registryName: __string,
    schemaName: __string,
    schemaVersion: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.DescribeCodeBindingRequest = {
    import DescribeCodeBindingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.DescribeCodeBindingRequest
      .builder()
      .language(__string.unwrap(language): java.lang.String)
      .registryName(__string.unwrap(registryName): java.lang.String)
      .schemaName(__string.unwrap(schemaName): java.lang.String)
      .optionallyWith(
        schemaVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaVersion)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.DescribeCodeBindingRequest.ReadOnly =
    zio.aws.schemas.model.DescribeCodeBindingRequest.wrap(buildAwsValue())
}
object DescribeCodeBindingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.DescribeCodeBindingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.DescribeCodeBindingRequest =
      zio.aws.schemas.model.DescribeCodeBindingRequest(
        language,
        registryName,
        schemaName,
        schemaVersion.map(value => value)
      )
    def language: __string
    def registryName: __string
    def schemaName: __string
    def schemaVersion: Option[__string]
    def getLanguage: ZIO[Any, Nothing, __string] = ZIO.succeed(language)
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaName: ZIO[Any, Nothing, __string] = ZIO.succeed(schemaName)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.DescribeCodeBindingRequest
  ) extends zio.aws.schemas.model.DescribeCodeBindingRequest.ReadOnly {
    override val language: __string =
      zio.aws.schemas.model.primitives.__string(impl.language())
    override val registryName: __string =
      zio.aws.schemas.model.primitives.__string(impl.registryName())
    override val schemaName: __string =
      zio.aws.schemas.model.primitives.__string(impl.schemaName())
    override val schemaVersion: Option[__string] = scala
      .Option(impl.schemaVersion())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.DescribeCodeBindingRequest
  ): zio.aws.schemas.model.DescribeCodeBindingRequest.ReadOnly = new Wrapper(
    impl
  )
}
