package zio.aws.schemas.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters._
final case class SearchSchemasRequest(
    keywords: __string,
    limit: Option[__integer] = None,
    nextToken: Option[__string] = None,
    registryName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.SearchSchemasRequest = {
    import SearchSchemasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.SearchSchemasRequest
      .builder()
      .keywords(__string.unwrap(keywords): java.lang.String)
      .optionallyWith(limit.map(value => __integer.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .registryName(__string.unwrap(registryName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.SearchSchemasRequest.ReadOnly =
    zio.aws.schemas.model.SearchSchemasRequest.wrap(buildAwsValue())
}
object SearchSchemasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.SearchSchemasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.SearchSchemasRequest =
      zio.aws.schemas.model.SearchSchemasRequest(
        keywords,
        limit.map(value => value),
        nextToken.map(value => value),
        registryName
      )
    def keywords: __string
    def limit: Option[__integer]
    def nextToken: Option[__string]
    def registryName: __string
    def getKeywords: ZIO[Any, Nothing, __string] = ZIO.succeed(keywords)
    def getLimit: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.SearchSchemasRequest
  ) extends zio.aws.schemas.model.SearchSchemasRequest.ReadOnly {
    override val keywords: __string =
      zio.aws.schemas.model.primitives.__string(impl.keywords())
    override val limit: Option[__integer] = scala
      .Option(impl.limit())
      .map(value => zio.aws.schemas.model.primitives.__integer(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val registryName: __string =
      zio.aws.schemas.model.primitives.__string(impl.registryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.SearchSchemasRequest
  ): zio.aws.schemas.model.SearchSchemasRequest.ReadOnly = new Wrapper(impl)
}
