package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ExportSchemaResponse(
    content: Option[__string] = None,
    schemaArn: Option[__string] = None,
    schemaName: Option[__string] = None,
    schemaVersion: Option[__string] = None,
    `type`: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ExportSchemaResponse = {
    import ExportSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ExportSchemaResponse
      .builder()
      .optionallyWith(
        content.map(value => __string.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        schemaArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .optionallyWith(
        schemaName.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaName)
      .optionallyWith(
        schemaVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaVersion)
      .optionallyWith(
        `type`.map(value => __string.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ExportSchemaResponse.ReadOnly =
    zio.aws.schemas.model.ExportSchemaResponse.wrap(buildAwsValue())
}
object ExportSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ExportSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ExportSchemaResponse =
      zio.aws.schemas.model.ExportSchemaResponse(
        content.map(value => value),
        schemaArn.map(value => value),
        schemaName.map(value => value),
        schemaVersion.map(value => value),
        `type`.map(value => value)
      )
    def content: Option[__string]
    def schemaArn: Option[__string]
    def schemaName: Option[__string]
    def schemaVersion: Option[__string]
    def `type`: Option[__string]
    def getContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("content", content)
    def getSchemaArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getSchemaName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ExportSchemaResponse
  ) extends zio.aws.schemas.model.ExportSchemaResponse.ReadOnly {
    override val content: Option[__string] = scala
      .Option(impl.content())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val schemaArn: Option[__string] = scala
      .Option(impl.schemaArn())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val schemaName: Option[__string] = scala
      .Option(impl.schemaName())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val schemaVersion: Option[__string] = scala
      .Option(impl.schemaVersion())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val `type`: Option[__string] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ExportSchemaResponse
  ): zio.aws.schemas.model.ExportSchemaResponse.ReadOnly = new Wrapper(impl)
}
