package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class SchemaVersionSummary(
    schemaArn: Option[__string] = None,
    schemaName: Option[__string] = None,
    schemaVersion: Option[__string] = None,
    `type`: Option[zio.aws.schemas.model.Type] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.SchemaVersionSummary = {
    import SchemaVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.SchemaVersionSummary
      .builder()
      .optionallyWith(
        schemaArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .optionallyWith(
        schemaName.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaName)
      .optionallyWith(
        schemaVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaVersion)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.SchemaVersionSummary.ReadOnly =
    zio.aws.schemas.model.SchemaVersionSummary.wrap(buildAwsValue())
}
object SchemaVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.SchemaVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.SchemaVersionSummary =
      zio.aws.schemas.model.SchemaVersionSummary(
        schemaArn.map(value => value),
        schemaName.map(value => value),
        schemaVersion.map(value => value),
        `type`.map(value => value)
      )
    def schemaArn: Option[__string]
    def schemaName: Option[__string]
    def schemaVersion: Option[__string]
    def `type`: Option[zio.aws.schemas.model.Type]
    def getSchemaArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getSchemaName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getType: ZIO[Any, AwsError, zio.aws.schemas.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.SchemaVersionSummary
  ) extends zio.aws.schemas.model.SchemaVersionSummary.ReadOnly {
    override val schemaArn: Option[__string] = scala
      .Option(impl.schemaArn())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val schemaName: Option[__string] = scala
      .Option(impl.schemaName())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val schemaVersion: Option[__string] = scala
      .Option(impl.schemaVersion())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val `type`: Option[zio.aws.schemas.model.Type] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.schemas.model.Type.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.SchemaVersionSummary
  ): zio.aws.schemas.model.SchemaVersionSummary.ReadOnly = new Wrapper(impl)
}
