package zio.aws.schemas.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.{__string, __integer}
import scala.jdk.CollectionConverters._
final case class ListRegistriesRequest(
    limit: Option[__integer] = None,
    nextToken: Option[__string] = None,
    registryNamePrefix: Option[__string] = None,
    scope: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ListRegistriesRequest = {
    import ListRegistriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ListRegistriesRequest
      .builder()
      .optionallyWith(limit.map(value => __integer.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        registryNamePrefix.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.registryNamePrefix)
      .optionallyWith(
        scope.map(value => __string.unwrap(value): java.lang.String)
      )(_.scope)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ListRegistriesRequest.ReadOnly =
    zio.aws.schemas.model.ListRegistriesRequest.wrap(buildAwsValue())
}
object ListRegistriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ListRegistriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ListRegistriesRequest =
      zio.aws.schemas.model.ListRegistriesRequest(
        limit.map(value => value),
        nextToken.map(value => value),
        registryNamePrefix.map(value => value),
        scope.map(value => value)
      )
    def limit: Option[__integer]
    def nextToken: Option[__string]
    def registryNamePrefix: Option[__string]
    def scope: Option[__string]
    def getLimit: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegistryNamePrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryNamePrefix", registryNamePrefix)
    def getScope: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ListRegistriesRequest
  ) extends zio.aws.schemas.model.ListRegistriesRequest.ReadOnly {
    override val limit: Option[__integer] = scala
      .Option(impl.limit())
      .map(value => zio.aws.schemas.model.primitives.__integer(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val registryNamePrefix: Option[__string] = scala
      .Option(impl.registryNamePrefix())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val scope: Option[__string] = scala
      .Option(impl.scope())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ListRegistriesRequest
  ): zio.aws.schemas.model.ListRegistriesRequest.ReadOnly = new Wrapper(impl)
}
