package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ExportSchemaRequest(
    registryName: __string,
    schemaName: __string,
    schemaVersion: Option[__string] = None,
    `type`: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ExportSchemaRequest = {
    import ExportSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ExportSchemaRequest
      .builder()
      .registryName(__string.unwrap(registryName): java.lang.String)
      .schemaName(__string.unwrap(schemaName): java.lang.String)
      .optionallyWith(
        schemaVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaVersion)
      .`type`(__string.unwrap(`type`): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ExportSchemaRequest.ReadOnly =
    zio.aws.schemas.model.ExportSchemaRequest.wrap(buildAwsValue())
}
object ExportSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ExportSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ExportSchemaRequest =
      zio.aws.schemas.model.ExportSchemaRequest(
        registryName,
        schemaName,
        schemaVersion.map(value => value),
        `type`
      )
    def registryName: __string
    def schemaName: __string
    def schemaVersion: Option[__string]
    def `type`: __string
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaName: ZIO[Any, Nothing, __string] = ZIO.succeed(schemaName)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getType: ZIO[Any, Nothing, __string] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ExportSchemaRequest
  ) extends zio.aws.schemas.model.ExportSchemaRequest.ReadOnly {
    override val registryName: __string =
      zio.aws.schemas.model.primitives.__string(impl.registryName())
    override val schemaName: __string =
      zio.aws.schemas.model.primitives.__string(impl.schemaName())
    override val schemaVersion: Option[__string] = scala
      .Option(impl.schemaVersion())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val `type`: __string =
      zio.aws.schemas.model.primitives.__string(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ExportSchemaRequest
  ): zio.aws.schemas.model.ExportSchemaRequest.ReadOnly = new Wrapper(impl)
}
