package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DeleteSchemaRequest(
    registryName: __string,
    schemaName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.DeleteSchemaRequest = {
    import DeleteSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.DeleteSchemaRequest
      .builder()
      .registryName(__string.unwrap(registryName): java.lang.String)
      .schemaName(__string.unwrap(schemaName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.DeleteSchemaRequest.ReadOnly =
    zio.aws.schemas.model.DeleteSchemaRequest.wrap(buildAwsValue())
}
object DeleteSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.DeleteSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.DeleteSchemaRequest =
      zio.aws.schemas.model.DeleteSchemaRequest(registryName, schemaName)
    def registryName: __string
    def schemaName: __string
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaName: ZIO[Any, Nothing, __string] = ZIO.succeed(schemaName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.DeleteSchemaRequest
  ) extends zio.aws.schemas.model.DeleteSchemaRequest.ReadOnly {
    override val registryName: __string =
      zio.aws.schemas.model.primitives.__string(impl.registryName())
    override val schemaName: __string =
      zio.aws.schemas.model.primitives.__string(impl.schemaName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.DeleteSchemaRequest
  ): zio.aws.schemas.model.DeleteSchemaRequest.ReadOnly = new Wrapper(impl)
}
