package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.schemas.model.primitives.{__timestampIso8601, __string}
import scala.jdk.CollectionConverters._
final case class UpdateSchemaResponse(
    description: Option[__string] = None,
    lastModified: Option[__timestampIso8601] = None,
    schemaArn: Option[__string] = None,
    schemaName: Option[__string] = None,
    schemaVersion: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None,
    `type`: Option[__string] = None,
    versionCreatedDate: Option[__timestampIso8601] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.UpdateSchemaResponse = {
    import UpdateSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.UpdateSchemaResponse
      .builder()
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        lastModified.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        schemaArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .optionallyWith(
        schemaName.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaName)
      .optionallyWith(
        schemaVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaVersion)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        `type`.map(value => __string.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        versionCreatedDate.map(value =>
          __timestampIso8601.unwrap(value): Instant
        )
      )(_.versionCreatedDate)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.UpdateSchemaResponse.ReadOnly =
    zio.aws.schemas.model.UpdateSchemaResponse.wrap(buildAwsValue())
}
object UpdateSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.UpdateSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.UpdateSchemaResponse =
      zio.aws.schemas.model.UpdateSchemaResponse(
        description.map(value => value),
        lastModified.map(value => value),
        schemaArn.map(value => value),
        schemaName.map(value => value),
        schemaVersion.map(value => value),
        tags.map(value => value),
        `type`.map(value => value),
        versionCreatedDate.map(value => value)
      )
    def description: Option[__string]
    def lastModified: Option[__timestampIso8601]
    def schemaArn: Option[__string]
    def schemaName: Option[__string]
    def schemaVersion: Option[__string]
    def tags: Option[Map[__string, __string]]
    def `type`: Option[__string]
    def versionCreatedDate: Option[__timestampIso8601]
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getLastModified: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getSchemaArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getSchemaName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("type", `type`)
    def getVersionCreatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("versionCreatedDate", versionCreatedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.UpdateSchemaResponse
  ) extends zio.aws.schemas.model.UpdateSchemaResponse.ReadOnly {
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val lastModified: Option[__timestampIso8601] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.schemas.model.primitives.__timestampIso8601(value))
    override val schemaArn: Option[__string] = scala
      .Option(impl.schemaArn())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val schemaName: Option[__string] = scala
      .Option(impl.schemaName())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val schemaVersion: Option[__string] = scala
      .Option(impl.schemaVersion())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.schemas.model.primitives
              .__string(key) -> zio.aws.schemas.model.primitives.__string(value)
          })
          .toMap
      )
    override val `type`: Option[__string] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val versionCreatedDate: Option[__timestampIso8601] = scala
      .Option(impl.versionCreatedDate())
      .map(value => zio.aws.schemas.model.primitives.__timestampIso8601(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.UpdateSchemaResponse
  ): zio.aws.schemas.model.UpdateSchemaResponse.ReadOnly = new Wrapper(impl)
}
