package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DeleteSchemaVersionRequest(
    registryName: __string,
    schemaName: __string,
    schemaVersion: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionRequest = {
    import DeleteSchemaVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionRequest
      .builder()
      .registryName(__string.unwrap(registryName): java.lang.String)
      .schemaName(__string.unwrap(schemaName): java.lang.String)
      .schemaVersion(__string.unwrap(schemaVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.DeleteSchemaVersionRequest.ReadOnly =
    zio.aws.schemas.model.DeleteSchemaVersionRequest.wrap(buildAwsValue())
}
object DeleteSchemaVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.DeleteSchemaVersionRequest =
      zio.aws.schemas.model
        .DeleteSchemaVersionRequest(registryName, schemaName, schemaVersion)
    def registryName: __string
    def schemaName: __string
    def schemaVersion: __string
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaName: ZIO[Any, Nothing, __string] = ZIO.succeed(schemaName)
    def getSchemaVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(schemaVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionRequest
  ) extends zio.aws.schemas.model.DeleteSchemaVersionRequest.ReadOnly {
    override val registryName: __string =
      zio.aws.schemas.model.primitives.__string(impl.registryName())
    override val schemaName: __string =
      zio.aws.schemas.model.primitives.__string(impl.schemaName())
    override val schemaVersion: __string =
      zio.aws.schemas.model.primitives.__string(impl.schemaVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionRequest
  ): zio.aws.schemas.model.DeleteSchemaVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
