package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.scheduler.model.primitives.ScheduleArn
import scala.jdk.CollectionConverters._
final case class UpdateScheduleResponse(scheduleArn: ScheduleArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.UpdateScheduleResponse = {
    import UpdateScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.UpdateScheduleResponse
      .builder()
      .scheduleArn(ScheduleArn.unwrap(scheduleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.UpdateScheduleResponse.ReadOnly =
    zio.aws.scheduler.model.UpdateScheduleResponse.wrap(buildAwsValue())
}
object UpdateScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.UpdateScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.UpdateScheduleResponse =
      zio.aws.scheduler.model.UpdateScheduleResponse(scheduleArn)
    def scheduleArn: ScheduleArn
    def getScheduleArn: ZIO[Any, Nothing, ScheduleArn] =
      ZIO.succeed(scheduleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.UpdateScheduleResponse
  ) extends zio.aws.scheduler.model.UpdateScheduleResponse.ReadOnly {
    override val scheduleArn: ScheduleArn =
      zio.aws.scheduler.model.primitives.ScheduleArn(impl.scheduleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.UpdateScheduleResponse
  ): zio.aws.scheduler.model.UpdateScheduleResponse.ReadOnly = new Wrapper(impl)
}
