package zio.aws.scheduler.model
import scala.jdk.CollectionConverters._
sealed trait ScheduleState {
  def unwrap: software.amazon.awssdk.services.scheduler.model.ScheduleState
}
object ScheduleState {
  def wrap(
      value: software.amazon.awssdk.services.scheduler.model.ScheduleState
  ): zio.aws.scheduler.model.ScheduleState = value match {
    case software.amazon.awssdk.services.scheduler.model.ScheduleState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.scheduler.model.ScheduleState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.scheduler.model.ScheduleState.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.scheduler.model.ScheduleState {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.ScheduleState =
      software.amazon.awssdk.services.scheduler.model.ScheduleState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.scheduler.model.ScheduleState {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.ScheduleState =
      software.amazon.awssdk.services.scheduler.model.ScheduleState.ENABLED
  }
  case object DISABLED extends zio.aws.scheduler.model.ScheduleState {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.ScheduleState =
      software.amazon.awssdk.services.scheduler.model.ScheduleState.DISABLED
  }
}
