package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.scheduler.model.primitives.{
  SageMakerPipelineParameterValue,
  SageMakerPipelineParameterName
}
import scala.jdk.CollectionConverters._
final case class SageMakerPipelineParameter(
    name: SageMakerPipelineParameterName,
    value: SageMakerPipelineParameterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.SageMakerPipelineParameter = {
    import SageMakerPipelineParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.SageMakerPipelineParameter
      .builder()
      .name(SageMakerPipelineParameterName.unwrap(name): java.lang.String)
      .value(SageMakerPipelineParameterValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.SageMakerPipelineParameter.ReadOnly =
    zio.aws.scheduler.model.SageMakerPipelineParameter.wrap(buildAwsValue())
}
object SageMakerPipelineParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.SageMakerPipelineParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.SageMakerPipelineParameter =
      zio.aws.scheduler.model.SageMakerPipelineParameter(name, value)
    def name: SageMakerPipelineParameterName
    def value: SageMakerPipelineParameterValue
    def getName: ZIO[Any, Nothing, SageMakerPipelineParameterName] =
      ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, SageMakerPipelineParameterValue] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.SageMakerPipelineParameter
  ) extends zio.aws.scheduler.model.SageMakerPipelineParameter.ReadOnly {
    override val name: SageMakerPipelineParameterName =
      zio.aws.scheduler.model.primitives
        .SageMakerPipelineParameterName(impl.name())
    override val value: SageMakerPipelineParameterValue =
      zio.aws.scheduler.model.primitives
        .SageMakerPipelineParameterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.SageMakerPipelineParameter
  ): zio.aws.scheduler.model.SageMakerPipelineParameter.ReadOnly = new Wrapper(
    impl
  )
}
