package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.scheduler.model.primitives.DeadLetterConfigArnString
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeadLetterConfig(
    arn: Optional[DeadLetterConfigArnString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.DeadLetterConfig = {
    import DeadLetterConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.DeadLetterConfig
      .builder()
      .optionallyWith(
        arn.map(value =>
          DeadLetterConfigArnString.unwrap(value): java.lang.String
        )
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.DeadLetterConfig.ReadOnly =
    zio.aws.scheduler.model.DeadLetterConfig.wrap(buildAwsValue())
}
object DeadLetterConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.DeadLetterConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.DeadLetterConfig =
      zio.aws.scheduler.model.DeadLetterConfig(arn.map(value => value))
    def arn: Optional[DeadLetterConfigArnString]
    def getArn: ZIO[Any, AwsError, DeadLetterConfigArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.DeadLetterConfig
  ) extends zio.aws.scheduler.model.DeadLetterConfig.ReadOnly {
    override val arn: Optional[DeadLetterConfigArnString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.scheduler.model.primitives.DeadLetterConfigArnString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.DeadLetterConfig
  ): zio.aws.scheduler.model.DeadLetterConfig.ReadOnly = new Wrapper(impl)
}
