package zio.aws.scheduler.model
import scala.jdk.CollectionConverters._
sealed trait ActionAfterCompletion {
  def unwrap
      : software.amazon.awssdk.services.scheduler.model.ActionAfterCompletion
}
object ActionAfterCompletion {
  def wrap(
      value: software.amazon.awssdk.services.scheduler.model.ActionAfterCompletion
  ): zio.aws.scheduler.model.ActionAfterCompletion = value match {
    case software.amazon.awssdk.services.scheduler.model.ActionAfterCompletion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.scheduler.model.ActionAfterCompletion.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.scheduler.model.ActionAfterCompletion.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.scheduler.model.ActionAfterCompletion {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.ActionAfterCompletion =
      software.amazon.awssdk.services.scheduler.model.ActionAfterCompletion.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.scheduler.model.ActionAfterCompletion {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.ActionAfterCompletion =
      software.amazon.awssdk.services.scheduler.model.ActionAfterCompletion.NONE
  }
  case object DELETE extends zio.aws.scheduler.model.ActionAfterCompletion {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.ActionAfterCompletion =
      software.amazon.awssdk.services.scheduler.model.ActionAfterCompletion.DELETE
  }
}
