package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.scheduler.model.primitives.TargetArn
import scala.jdk.CollectionConverters._
final case class TargetSummary(arn: TargetArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.TargetSummary = {
    import TargetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.TargetSummary
      .builder()
      .arn(TargetArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.TargetSummary.ReadOnly =
    zio.aws.scheduler.model.TargetSummary.wrap(buildAwsValue())
}
object TargetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.TargetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.TargetSummary =
      zio.aws.scheduler.model.TargetSummary(arn)
    def arn: TargetArn
    def getArn: ZIO[Any, Nothing, TargetArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.TargetSummary
  ) extends zio.aws.scheduler.model.TargetSummary.ReadOnly {
    override val arn: TargetArn =
      zio.aws.scheduler.model.primitives.TargetArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.TargetSummary
  ): zio.aws.scheduler.model.TargetSummary.ReadOnly = new Wrapper(impl)
}
