package zio.aws.scheduler.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.scheduler.model.primitives.{
  ScheduleGroupName,
  LastModificationDate,
  CreationDate,
  ScheduleGroupArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ScheduleGroupSummary(
    arn: Optional[ScheduleGroupArn] = Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent,
    lastModificationDate: Optional[LastModificationDate] = Optional.Absent,
    name: Optional[ScheduleGroupName] = Optional.Absent,
    state: Optional[zio.aws.scheduler.model.ScheduleGroupState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.ScheduleGroupSummary = {
    import ScheduleGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.ScheduleGroupSummary
      .builder()
      .optionallyWith(
        arn.map(value => ScheduleGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModificationDate.map(value =>
          LastModificationDate.unwrap(value): Instant
        )
      )(_.lastModificationDate)
      .optionallyWith(
        name.map(value => ScheduleGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.ScheduleGroupSummary.ReadOnly =
    zio.aws.scheduler.model.ScheduleGroupSummary.wrap(buildAwsValue())
}
object ScheduleGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.ScheduleGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.ScheduleGroupSummary =
      zio.aws.scheduler.model.ScheduleGroupSummary(
        arn.map(value => value),
        creationDate.map(value => value),
        lastModificationDate.map(value => value),
        name.map(value => value),
        state.map(value => value)
      )
    def arn: Optional[ScheduleGroupArn]
    def creationDate: Optional[CreationDate]
    def lastModificationDate: Optional[LastModificationDate]
    def name: Optional[ScheduleGroupName]
    def state: Optional[zio.aws.scheduler.model.ScheduleGroupState]
    def getArn: ZIO[Any, AwsError, ScheduleGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModificationDate: ZIO[Any, AwsError, LastModificationDate] =
      AwsError.unwrapOptionField("lastModificationDate", lastModificationDate)
    def getName: ZIO[Any, AwsError, ScheduleGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getState
        : ZIO[Any, AwsError, zio.aws.scheduler.model.ScheduleGroupState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.ScheduleGroupSummary
  ) extends zio.aws.scheduler.model.ScheduleGroupSummary.ReadOnly {
    override val arn: Optional[ScheduleGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.scheduler.model.primitives.ScheduleGroupArn(value))
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.scheduler.model.primitives.CreationDate(value))
    override val lastModificationDate: Optional[LastModificationDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationDate())
        .map(value =>
          zio.aws.scheduler.model.primitives.LastModificationDate(value)
        )
    override val name: Optional[ScheduleGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.scheduler.model.primitives.ScheduleGroupName(value))
    override val state: Optional[zio.aws.scheduler.model.ScheduleGroupState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.scheduler.model.ScheduleGroupState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.ScheduleGroupSummary
  ): zio.aws.scheduler.model.ScheduleGroupSummary.ReadOnly = new Wrapper(impl)
}
