package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Optional[Iterable[zio.aws.scheduler.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.scheduler.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.ListTagsForResourceResponse =
      zio.aws.scheduler.model.ListTagsForResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Optional[List[zio.aws.scheduler.model.Tag.ReadOnly]]
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.scheduler.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.ListTagsForResourceResponse
  ) extends zio.aws.scheduler.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Optional[List[zio.aws.scheduler.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.scheduler.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.ListTagsForResourceResponse
  ): zio.aws.scheduler.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
