package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.scheduler.model.primitives.TagResourceArn
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: TagResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(TagResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.scheduler.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.ListTagsForResourceRequest =
      zio.aws.scheduler.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: TagResourceArn
    def getResourceArn: ZIO[Any, Nothing, TagResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.ListTagsForResourceRequest
  ) extends zio.aws.scheduler.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: TagResourceArn =
      zio.aws.scheduler.model.primitives.TagResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.ListTagsForResourceRequest
  ): zio.aws.scheduler.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
