package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.scheduler.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSchedulesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    schedules: Iterable[zio.aws.scheduler.model.ScheduleSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse = {
    import ListSchedulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .schedules(schedules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.ListSchedulesResponse.ReadOnly =
    zio.aws.scheduler.model.ListSchedulesResponse.wrap(buildAwsValue())
}
object ListSchedulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.ListSchedulesResponse =
      zio.aws.scheduler.model.ListSchedulesResponse(
        nextToken.map(value => value),
        schedules.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def schedules: List[zio.aws.scheduler.model.ScheduleSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSchedules: ZIO[Any, Nothing, List[
      zio.aws.scheduler.model.ScheduleSummary.ReadOnly
    ]] = ZIO.succeed(schedules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse
  ) extends zio.aws.scheduler.model.ListSchedulesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.scheduler.model.primitives.NextToken(value))
    override val schedules
        : List[zio.aws.scheduler.model.ScheduleSummary.ReadOnly] = impl
      .schedules()
      .asScala
      .map { item =>
        zio.aws.scheduler.model.ScheduleSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse
  ): zio.aws.scheduler.model.ListSchedulesResponse.ReadOnly = new Wrapper(impl)
}
