package zio.aws.scheduler.model
import zio.prelude.data.Optional
import zio.aws.scheduler.model.primitives.{
  NextToken,
  NamePrefix,
  MaxResults,
  ScheduleGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSchedulesRequest(
    groupName: Optional[ScheduleGroupName] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    namePrefix: Optional[NamePrefix] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    state: Optional[zio.aws.scheduler.model.ScheduleState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest = {
    import ListSchedulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest
      .builder()
      .optionallyWith(
        groupName.map(value =>
          ScheduleGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        namePrefix.map(value => NamePrefix.unwrap(value): java.lang.String)
      )(_.namePrefix)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.ListSchedulesRequest.ReadOnly =
    zio.aws.scheduler.model.ListSchedulesRequest.wrap(buildAwsValue())
}
object ListSchedulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.ListSchedulesRequest =
      zio.aws.scheduler.model.ListSchedulesRequest(
        groupName.map(value => value),
        maxResults.map(value => value),
        namePrefix.map(value => value),
        nextToken.map(value => value),
        state.map(value => value)
      )
    def groupName: Optional[ScheduleGroupName]
    def maxResults: Optional[MaxResults]
    def namePrefix: Optional[NamePrefix]
    def nextToken: Optional[NextToken]
    def state: Optional[zio.aws.scheduler.model.ScheduleState]
    def getGroupName: ZIO[Any, AwsError, ScheduleGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNamePrefix: ZIO[Any, AwsError, NamePrefix] =
      AwsError.unwrapOptionField("namePrefix", namePrefix)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getState: ZIO[Any, AwsError, zio.aws.scheduler.model.ScheduleState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest
  ) extends zio.aws.scheduler.model.ListSchedulesRequest.ReadOnly {
    override val groupName: Optional[ScheduleGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.scheduler.model.primitives.ScheduleGroupName(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.scheduler.model.primitives.MaxResults(value))
    override val namePrefix: Optional[NamePrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.namePrefix())
      .map(value => zio.aws.scheduler.model.primitives.NamePrefix(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.scheduler.model.primitives.NextToken(value))
    override val state: Optional[zio.aws.scheduler.model.ScheduleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.scheduler.model.ScheduleState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest
  ): zio.aws.scheduler.model.ListSchedulesRequest.ReadOnly = new Wrapper(impl)
}
