package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.scheduler.model.primitives.ScheduleGroupName
import scala.jdk.CollectionConverters._
final case class GetScheduleGroupRequest(name: ScheduleGroupName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.GetScheduleGroupRequest = {
    import GetScheduleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.GetScheduleGroupRequest
      .builder()
      .name(ScheduleGroupName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.GetScheduleGroupRequest.ReadOnly =
    zio.aws.scheduler.model.GetScheduleGroupRequest.wrap(buildAwsValue())
}
object GetScheduleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.GetScheduleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.GetScheduleGroupRequest =
      zio.aws.scheduler.model.GetScheduleGroupRequest(name)
    def name: ScheduleGroupName
    def getName: ZIO[Any, Nothing, ScheduleGroupName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.GetScheduleGroupRequest
  ) extends zio.aws.scheduler.model.GetScheduleGroupRequest.ReadOnly {
    override val name: ScheduleGroupName =
      zio.aws.scheduler.model.primitives.ScheduleGroupName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.GetScheduleGroupRequest
  ): zio.aws.scheduler.model.GetScheduleGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
