package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.scheduler.model.primitives.{Name, ScheduleGroupName, ClientToken}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteScheduleRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    groupName: Optional[ScheduleGroupName] = Optional.Absent,
    name: Name
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.DeleteScheduleRequest = {
    import DeleteScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.DeleteScheduleRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        groupName.map(value =>
          ScheduleGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.DeleteScheduleRequest.ReadOnly =
    zio.aws.scheduler.model.DeleteScheduleRequest.wrap(buildAwsValue())
}
object DeleteScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.DeleteScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.DeleteScheduleRequest =
      zio.aws.scheduler.model.DeleteScheduleRequest(
        clientToken.map(value => value),
        groupName.map(value => value),
        name
      )
    def clientToken: Optional[ClientToken]
    def groupName: Optional[ScheduleGroupName]
    def name: Name
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getGroupName: ZIO[Any, AwsError, ScheduleGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.DeleteScheduleRequest
  ) extends zio.aws.scheduler.model.DeleteScheduleRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.scheduler.model.primitives.ClientToken(value))
    override val groupName: Optional[ScheduleGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.scheduler.model.primitives.ScheduleGroupName(value))
    override val name: Name =
      zio.aws.scheduler.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.DeleteScheduleRequest
  ): zio.aws.scheduler.model.DeleteScheduleRequest.ReadOnly = new Wrapper(impl)
}
