package zio.aws.scheduler
import zio.aws.scheduler.model.GetScheduleGroupResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.scheduler.model.{
  ListSchedulesRequest,
  DeleteScheduleRequest,
  CreateScheduleGroupRequest,
  ListTagsForResourceRequest,
  GetScheduleRequest,
  CreateScheduleRequest,
  DeleteScheduleGroupRequest,
  GetScheduleGroupRequest,
  ListScheduleGroupsRequest,
  UntagResourceRequest,
  UpdateScheduleRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.scheduler.{
  SchedulerAsyncClientBuilder,
  SchedulerAsyncClient
}
import software.amazon.awssdk.services.scheduler.model.{
  CreateScheduleResponse,
  ScheduleGroupSummary,
  UpdateScheduleResponse,
  ScheduleSummary,
  DeleteScheduleResponse,
  GetScheduleGroupResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListScheduleGroupsResponse,
  DeleteScheduleGroupResponse,
  GetScheduleResponse,
  TagResourceResponse,
  ListSchedulesResponse,
  CreateScheduleGroupResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Scheduler extends AspectSupport[Scheduler] {
  val api: SchedulerAsyncClient
  def createSchedule(
      request: CreateScheduleRequest
  ): IO[AwsError, zio.aws.scheduler.model.CreateScheduleResponse.ReadOnly]
  def listSchedules(
      request: ListSchedulesRequest
  ): ZStream[Any, AwsError, zio.aws.scheduler.model.ScheduleSummary.ReadOnly]
  def listSchedulesPaginated(
      request: ListSchedulesRequest
  ): IO[AwsError, zio.aws.scheduler.model.ListSchedulesResponse.ReadOnly]
  def getSchedule(
      request: GetScheduleRequest
  ): IO[AwsError, zio.aws.scheduler.model.GetScheduleResponse.ReadOnly]
  def updateSchedule(
      request: UpdateScheduleRequest
  ): IO[AwsError, zio.aws.scheduler.model.UpdateScheduleResponse.ReadOnly]
  def createScheduleGroup(
      request: CreateScheduleGroupRequest
  ): IO[AwsError, zio.aws.scheduler.model.CreateScheduleGroupResponse.ReadOnly]
  def getScheduleGroup(request: GetScheduleGroupRequest): IO[AwsError, ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.scheduler.model.UntagResourceResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.scheduler.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.scheduler.model.TagResourceResponse.ReadOnly]
  def deleteScheduleGroup(
      request: DeleteScheduleGroupRequest
  ): IO[AwsError, zio.aws.scheduler.model.DeleteScheduleGroupResponse.ReadOnly]
  def deleteSchedule(
      request: DeleteScheduleRequest
  ): IO[AwsError, zio.aws.scheduler.model.DeleteScheduleResponse.ReadOnly]
  def listScheduleGroups(request: ListScheduleGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.scheduler.model.ScheduleGroupSummary.ReadOnly
  ]
  def listScheduleGroupsPaginated(
      request: ListScheduleGroupsRequest
  ): IO[AwsError, zio.aws.scheduler.model.ListScheduleGroupsResponse.ReadOnly]
}
object Scheduler {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Scheduler] = customized(
    identity
  )
  def customized(
      customization: SchedulerAsyncClientBuilder => SchedulerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Scheduler] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SchedulerAsyncClientBuilder => SchedulerAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Scheduler] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SchedulerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SchedulerAsyncClient, SchedulerAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[SchedulerAsyncClient, SchedulerAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new SchedulerImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SchedulerImpl[R](
      override val api: SchedulerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Scheduler
      with AwsServiceBase[R] {
    override val serviceName: String = "Scheduler"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SchedulerImpl[R1] = new SchedulerImpl(api, newAspect, r)
    def createSchedule(
        request: CreateScheduleRequest
    ): IO[AwsError, zio.aws.scheduler.model.CreateScheduleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.scheduler.model.CreateScheduleRequest,
        CreateScheduleResponse
      ]("createSchedule", api.createSchedule)(request.buildAwsValue())
        .map(zio.aws.scheduler.model.CreateScheduleResponse.wrap)
        .provideEnvironment(r)
    def listSchedules(request: ListSchedulesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.scheduler.model.ScheduleSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest,
      ListSchedulesResponse,
      ScheduleSummary
    ](
      "listSchedules",
      api.listSchedules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.schedules().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.scheduler.model.ScheduleSummary.wrap(item))
      .provideEnvironment(r)
    def listSchedulesPaginated(
        request: ListSchedulesRequest
    ): IO[AwsError, zio.aws.scheduler.model.ListSchedulesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest,
        ListSchedulesResponse
      ]("listSchedules", api.listSchedules)(request.buildAwsValue())
        .map(zio.aws.scheduler.model.ListSchedulesResponse.wrap)
        .provideEnvironment(r)
    def getSchedule(
        request: GetScheduleRequest
    ): IO[AwsError, zio.aws.scheduler.model.GetScheduleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.scheduler.model.GetScheduleRequest,
        GetScheduleResponse
      ]("getSchedule", api.getSchedule)(request.buildAwsValue())
        .map(zio.aws.scheduler.model.GetScheduleResponse.wrap)
        .provideEnvironment(r)
    def updateSchedule(
        request: UpdateScheduleRequest
    ): IO[AwsError, zio.aws.scheduler.model.UpdateScheduleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.scheduler.model.UpdateScheduleRequest,
        UpdateScheduleResponse
      ]("updateSchedule", api.updateSchedule)(request.buildAwsValue())
        .map(zio.aws.scheduler.model.UpdateScheduleResponse.wrap)
        .provideEnvironment(r)
    def createScheduleGroup(request: CreateScheduleGroupRequest): IO[
      AwsError,
      zio.aws.scheduler.model.CreateScheduleGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupRequest,
      CreateScheduleGroupResponse
    ]("createScheduleGroup", api.createScheduleGroup)(request.buildAwsValue())
      .map(zio.aws.scheduler.model.CreateScheduleGroupResponse.wrap)
      .provideEnvironment(r)
    def getScheduleGroup(
        request: GetScheduleGroupRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.scheduler.model.GetScheduleGroupRequest,
      GetScheduleGroupResponse
    ]("getScheduleGroup", api.getScheduleGroup)(request.buildAwsValue())
      .map(zio.aws.scheduler.model.GetScheduleGroupResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.scheduler.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.scheduler.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.scheduler.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.scheduler.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.scheduler.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.scheduler.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.scheduler.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.scheduler.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.scheduler.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteScheduleGroup(request: DeleteScheduleGroupRequest): IO[
      AwsError,
      zio.aws.scheduler.model.DeleteScheduleGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.scheduler.model.DeleteScheduleGroupRequest,
      DeleteScheduleGroupResponse
    ]("deleteScheduleGroup", api.deleteScheduleGroup)(request.buildAwsValue())
      .map(zio.aws.scheduler.model.DeleteScheduleGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteSchedule(
        request: DeleteScheduleRequest
    ): IO[AwsError, zio.aws.scheduler.model.DeleteScheduleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.scheduler.model.DeleteScheduleRequest,
        DeleteScheduleResponse
      ]("deleteSchedule", api.deleteSchedule)(request.buildAwsValue())
        .map(zio.aws.scheduler.model.DeleteScheduleResponse.wrap)
        .provideEnvironment(r)
    def listScheduleGroups(request: ListScheduleGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.scheduler.model.ScheduleGroupSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest,
      ListScheduleGroupsResponse,
      ScheduleGroupSummary
    ](
      "listScheduleGroups",
      api.listScheduleGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.scheduleGroups().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.scheduler.model.ScheduleGroupSummary.wrap(item))
      .provideEnvironment(r)
    def listScheduleGroupsPaginated(request: ListScheduleGroupsRequest): IO[
      AwsError,
      zio.aws.scheduler.model.ListScheduleGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest,
      ListScheduleGroupsResponse
    ]("listScheduleGroups", api.listScheduleGroups)(request.buildAwsValue())
      .map(zio.aws.scheduler.model.ListScheduleGroupsResponse.wrap)
      .provideEnvironment(r)
  }
  def createSchedule(request: CreateScheduleRequest): ZIO[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.CreateScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSchedule(request))
  def listSchedules(request: ListSchedulesRequest): ZStream[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.ScheduleSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSchedules(request))
  def listSchedulesPaginated(request: ListSchedulesRequest): ZIO[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.ListSchedulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSchedulesPaginated(request))
  def getSchedule(request: GetScheduleRequest): ZIO[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.GetScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSchedule(request))
  def updateSchedule(request: UpdateScheduleRequest): ZIO[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.UpdateScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSchedule(request))
  def createScheduleGroup(request: CreateScheduleGroupRequest): ZIO[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.CreateScheduleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createScheduleGroup(request))
  def getScheduleGroup(
      request: GetScheduleGroupRequest
  ): ZIO[zio.aws.scheduler.Scheduler, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getScheduleGroup(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteScheduleGroup(request: DeleteScheduleGroupRequest): ZIO[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.DeleteScheduleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteScheduleGroup(request))
  def deleteSchedule(request: DeleteScheduleRequest): ZIO[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.DeleteScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSchedule(request))
  def listScheduleGroups(request: ListScheduleGroupsRequest): ZStream[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.ScheduleGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listScheduleGroups(request))
  def listScheduleGroupsPaginated(request: ListScheduleGroupsRequest): ZIO[
    zio.aws.scheduler.Scheduler,
    AwsError,
    zio.aws.scheduler.model.ListScheduleGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listScheduleGroupsPaginated(request))
}
