package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.scheduler.model.primitives.MessageGroupId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SqsParameters(
    messageGroupId: Optional[MessageGroupId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.SqsParameters = {
    import SqsParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.SqsParameters
      .builder()
      .optionallyWith(
        messageGroupId.map(value =>
          MessageGroupId.unwrap(value): java.lang.String
        )
      )(_.messageGroupId)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.SqsParameters.ReadOnly =
    zio.aws.scheduler.model.SqsParameters.wrap(buildAwsValue())
}
object SqsParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.SqsParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.SqsParameters =
      zio.aws.scheduler.model.SqsParameters(messageGroupId.map(value => value))
    def messageGroupId: Optional[MessageGroupId]
    def getMessageGroupId: ZIO[Any, AwsError, MessageGroupId] =
      AwsError.unwrapOptionField("messageGroupId", messageGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.SqsParameters
  ) extends zio.aws.scheduler.model.SqsParameters.ReadOnly {
    override val messageGroupId: Optional[MessageGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageGroupId())
        .map(value => zio.aws.scheduler.model.primitives.MessageGroupId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.SqsParameters
  ): zio.aws.scheduler.model.SqsParameters.ReadOnly = new Wrapper(impl)
}
