package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.scheduler.model.primitives.PlacementStrategyField
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PlacementStrategy(
    field: Optional[PlacementStrategyField] = Optional.Absent,
    `type`: Optional[zio.aws.scheduler.model.PlacementStrategyType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.PlacementStrategy = {
    import PlacementStrategy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.PlacementStrategy
      .builder()
      .optionallyWith(
        field.map(value =>
          PlacementStrategyField.unwrap(value): java.lang.String
        )
      )(_.field)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.PlacementStrategy.ReadOnly =
    zio.aws.scheduler.model.PlacementStrategy.wrap(buildAwsValue())
}
object PlacementStrategy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.PlacementStrategy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.PlacementStrategy =
      zio.aws.scheduler.model.PlacementStrategy(
        field.map(value => value),
        `type`.map(value => value)
      )
    def field: Optional[PlacementStrategyField]
    def `type`: Optional[zio.aws.scheduler.model.PlacementStrategyType]
    def getField: ZIO[Any, AwsError, PlacementStrategyField] =
      AwsError.unwrapOptionField("field", field)
    def getType
        : ZIO[Any, AwsError, zio.aws.scheduler.model.PlacementStrategyType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.PlacementStrategy
  ) extends zio.aws.scheduler.model.PlacementStrategy.ReadOnly {
    override val field: Optional[PlacementStrategyField] = zio.aws.core.internal
      .optionalFromNullable(impl.field())
      .map(value =>
        zio.aws.scheduler.model.primitives.PlacementStrategyField(value)
      )
    override val `type`
        : Optional[zio.aws.scheduler.model.PlacementStrategyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.scheduler.model.PlacementStrategyType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.PlacementStrategy
  ): zio.aws.scheduler.model.PlacementStrategy.ReadOnly = new Wrapper(impl)
}
