package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkConfiguration(
    awsvpcConfiguration: Optional[zio.aws.scheduler.model.AwsVpcConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.NetworkConfiguration = {
    import NetworkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.NetworkConfiguration
      .builder()
      .optionallyWith(awsvpcConfiguration.map(value => value.buildAwsValue()))(
        _.awsvpcConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.NetworkConfiguration.ReadOnly =
    zio.aws.scheduler.model.NetworkConfiguration.wrap(buildAwsValue())
}
object NetworkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.NetworkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.NetworkConfiguration =
      zio.aws.scheduler.model.NetworkConfiguration(
        awsvpcConfiguration.map(value => value.asEditable)
      )
    def awsvpcConfiguration
        : Optional[zio.aws.scheduler.model.AwsVpcConfiguration.ReadOnly]
    def getAwsvpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.scheduler.model.AwsVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("awsvpcConfiguration", awsvpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.NetworkConfiguration
  ) extends zio.aws.scheduler.model.NetworkConfiguration.ReadOnly {
    override val awsvpcConfiguration
        : Optional[zio.aws.scheduler.model.AwsVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsvpcConfiguration())
        .map(value => zio.aws.scheduler.model.AwsVpcConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.NetworkConfiguration
  ): zio.aws.scheduler.model.NetworkConfiguration.ReadOnly = new Wrapper(impl)
}
