package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.scheduler.model.primitives.ScheduleGroupArn
import scala.jdk.CollectionConverters._
final case class CreateScheduleGroupResponse(
    scheduleGroupArn: ScheduleGroupArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupResponse = {
    import CreateScheduleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupResponse
      .builder()
      .scheduleGroupArn(
        ScheduleGroupArn.unwrap(scheduleGroupArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.CreateScheduleGroupResponse.ReadOnly =
    zio.aws.scheduler.model.CreateScheduleGroupResponse.wrap(buildAwsValue())
}
object CreateScheduleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.CreateScheduleGroupResponse =
      zio.aws.scheduler.model.CreateScheduleGroupResponse(scheduleGroupArn)
    def scheduleGroupArn: ScheduleGroupArn
    def getScheduleGroupArn: ZIO[Any, Nothing, ScheduleGroupArn] =
      ZIO.succeed(scheduleGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupResponse
  ) extends zio.aws.scheduler.model.CreateScheduleGroupResponse.ReadOnly {
    override val scheduleGroupArn: ScheduleGroupArn =
      zio.aws.scheduler.model.primitives
        .ScheduleGroupArn(impl.scheduleGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupResponse
  ): zio.aws.scheduler.model.CreateScheduleGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
