package zio.aws.scheduler.model
import zio.prelude.data.Optional
import zio.aws.scheduler.model.primitives.{
  CapacityProviderStrategyItemWeight,
  CapacityProvider,
  CapacityProviderStrategyItemBase
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CapacityProviderStrategyItem(
    base: Optional[CapacityProviderStrategyItemBase] = Optional.Absent,
    capacityProvider: CapacityProvider,
    weight: Optional[CapacityProviderStrategyItemWeight] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.CapacityProviderStrategyItem = {
    import CapacityProviderStrategyItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.CapacityProviderStrategyItem
      .builder()
      .optionallyWith(
        base.map(value =>
          CapacityProviderStrategyItemBase.unwrap(value): Integer
        )
      )(_.base)
      .capacityProvider(
        CapacityProvider.unwrap(capacityProvider): java.lang.String
      )
      .optionallyWith(
        weight.map(value =>
          CapacityProviderStrategyItemWeight.unwrap(value): Integer
        )
      )(_.weight)
      .build()
  }
  def asReadOnly
      : zio.aws.scheduler.model.CapacityProviderStrategyItem.ReadOnly =
    zio.aws.scheduler.model.CapacityProviderStrategyItem.wrap(buildAwsValue())
}
object CapacityProviderStrategyItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.CapacityProviderStrategyItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.CapacityProviderStrategyItem =
      zio.aws.scheduler.model.CapacityProviderStrategyItem(
        base.map(value => value),
        capacityProvider,
        weight.map(value => value)
      )
    def base: Optional[CapacityProviderStrategyItemBase]
    def capacityProvider: CapacityProvider
    def weight: Optional[CapacityProviderStrategyItemWeight]
    def getBase: ZIO[Any, AwsError, CapacityProviderStrategyItemBase] =
      AwsError.unwrapOptionField("base", base)
    def getCapacityProvider: ZIO[Any, Nothing, CapacityProvider] =
      ZIO.succeed(capacityProvider)
    def getWeight: ZIO[Any, AwsError, CapacityProviderStrategyItemWeight] =
      AwsError.unwrapOptionField("weight", weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.CapacityProviderStrategyItem
  ) extends zio.aws.scheduler.model.CapacityProviderStrategyItem.ReadOnly {
    override val base: Optional[CapacityProviderStrategyItemBase] =
      zio.aws.core.internal
        .optionalFromNullable(impl.base())
        .map(value =>
          zio.aws.scheduler.model.primitives
            .CapacityProviderStrategyItemBase(value)
        )
    override val capacityProvider: CapacityProvider =
      zio.aws.scheduler.model.primitives
        .CapacityProvider(impl.capacityProvider())
    override val weight: Optional[CapacityProviderStrategyItemWeight] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weight())
        .map(value =>
          zio.aws.scheduler.model.primitives
            .CapacityProviderStrategyItemWeight(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.CapacityProviderStrategyItem
  ): zio.aws.scheduler.model.CapacityProviderStrategyItem.ReadOnly =
    new Wrapper(impl)
}
