package zio.aws.scheduler
import zio.aws.scheduler.model.GetScheduleGroupResponse.ReadOnly
import zio.aws.scheduler.model.{
  ListSchedulesRequest,
  DeleteScheduleRequest,
  CreateScheduleGroupRequest,
  ListTagsForResourceRequest,
  GetScheduleRequest,
  CreateScheduleRequest,
  DeleteScheduleGroupRequest,
  GetScheduleGroupRequest,
  ListScheduleGroupsRequest,
  UntagResourceRequest,
  UpdateScheduleRequest,
  TagResourceRequest
}
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.scheduler.SchedulerAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object SchedulerMock extends Mock[Scheduler] {
  object CreateSchedule
      extends Effect[
        CreateScheduleRequest,
        AwsError,
        zio.aws.scheduler.model.CreateScheduleResponse.ReadOnly
      ]
  object ListSchedules
      extends Stream[
        ListSchedulesRequest,
        AwsError,
        zio.aws.scheduler.model.ScheduleSummary.ReadOnly
      ]
  object ListSchedulesPaginated
      extends Effect[
        ListSchedulesRequest,
        AwsError,
        zio.aws.scheduler.model.ListSchedulesResponse.ReadOnly
      ]
  object GetSchedule
      extends Effect[
        GetScheduleRequest,
        AwsError,
        zio.aws.scheduler.model.GetScheduleResponse.ReadOnly
      ]
  object UpdateSchedule
      extends Effect[
        UpdateScheduleRequest,
        AwsError,
        zio.aws.scheduler.model.UpdateScheduleResponse.ReadOnly
      ]
  object CreateScheduleGroup
      extends Effect[
        CreateScheduleGroupRequest,
        AwsError,
        zio.aws.scheduler.model.CreateScheduleGroupResponse.ReadOnly
      ]
  object GetScheduleGroup
      extends Effect[GetScheduleGroupRequest, AwsError, ReadOnly]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.scheduler.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.scheduler.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.scheduler.model.TagResourceResponse.ReadOnly
      ]
  object DeleteScheduleGroup
      extends Effect[
        DeleteScheduleGroupRequest,
        AwsError,
        zio.aws.scheduler.model.DeleteScheduleGroupResponse.ReadOnly
      ]
  object DeleteSchedule
      extends Effect[
        DeleteScheduleRequest,
        AwsError,
        zio.aws.scheduler.model.DeleteScheduleResponse.ReadOnly
      ]
  object ListScheduleGroups
      extends Stream[
        ListScheduleGroupsRequest,
        AwsError,
        zio.aws.scheduler.model.ScheduleGroupSummary.ReadOnly
      ]
  object ListScheduleGroupsPaginated
      extends Effect[
        ListScheduleGroupsRequest,
        AwsError,
        zio.aws.scheduler.model.ListScheduleGroupsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Scheduler] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Scheduler] { rts =>
        zio.ZIO.succeed {
          new Scheduler {
            val api: SchedulerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Scheduler = this
            def createSchedule(request: CreateScheduleRequest): IO[
              AwsError,
              zio.aws.scheduler.model.CreateScheduleResponse.ReadOnly
            ] = proxy(CreateSchedule, request)
            def listSchedules(request: ListSchedulesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.scheduler.model.ScheduleSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSchedules, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSchedulesPaginated(request: ListSchedulesRequest): IO[
              AwsError,
              zio.aws.scheduler.model.ListSchedulesResponse.ReadOnly
            ] = proxy(ListSchedulesPaginated, request)
            def getSchedule(request: GetScheduleRequest): IO[
              AwsError,
              zio.aws.scheduler.model.GetScheduleResponse.ReadOnly
            ] = proxy(GetSchedule, request)
            def updateSchedule(request: UpdateScheduleRequest): IO[
              AwsError,
              zio.aws.scheduler.model.UpdateScheduleResponse.ReadOnly
            ] = proxy(UpdateSchedule, request)
            def createScheduleGroup(request: CreateScheduleGroupRequest): IO[
              AwsError,
              zio.aws.scheduler.model.CreateScheduleGroupResponse.ReadOnly
            ] = proxy(CreateScheduleGroup, request)
            def getScheduleGroup(
                request: GetScheduleGroupRequest
            ): IO[AwsError, ReadOnly] = proxy(GetScheduleGroup, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.scheduler.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.scheduler.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.scheduler.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def deleteScheduleGroup(request: DeleteScheduleGroupRequest): IO[
              AwsError,
              zio.aws.scheduler.model.DeleteScheduleGroupResponse.ReadOnly
            ] = proxy(DeleteScheduleGroup, request)
            def deleteSchedule(request: DeleteScheduleRequest): IO[
              AwsError,
              zio.aws.scheduler.model.DeleteScheduleResponse.ReadOnly
            ] = proxy(DeleteSchedule, request)
            def listScheduleGroups(request: ListScheduleGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.scheduler.model.ScheduleGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListScheduleGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listScheduleGroupsPaginated(
                request: ListScheduleGroupsRequest
            ): IO[
              AwsError,
              zio.aws.scheduler.model.ListScheduleGroupsResponse.ReadOnly
            ] = proxy(ListScheduleGroupsPaginated, request)
          }
        }
      }
    }
  }
}
