package zio.aws.sagemakerruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakerruntime.model.primitives.{
  TargetVariantHeader,
  InferenceId,
  EndpointName,
  TargetModelHeader,
  TargetContainerHostnameHeader,
  EnableExplanationsHeader,
  CustomAttributesHeader,
  BodyBlob,
  Header
}
import scala.jdk.CollectionConverters.*
final case class InvokeEndpointRequest(
    endpointName: EndpointName,
    body: BodyBlob,
    contentType: Optional[Header] = Optional.Absent,
    accept: Optional[Header] = Optional.Absent,
    customAttributes: Optional[CustomAttributesHeader] = Optional.Absent,
    targetModel: Optional[TargetModelHeader] = Optional.Absent,
    targetVariant: Optional[TargetVariantHeader] = Optional.Absent,
    targetContainerHostname: Optional[TargetContainerHostnameHeader] =
      Optional.Absent,
    inferenceId: Optional[InferenceId] = Optional.Absent,
    enableExplanations: Optional[EnableExplanationsHeader] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointRequest = {
    import InvokeEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointRequest
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .body(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          body.toArray[Byte]
        )
      )
      .optionallyWith(
        contentType.map(value => Header.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        accept.map(value => Header.unwrap(value): java.lang.String)
      )(_.accept)
      .optionallyWith(
        customAttributes.map(value =>
          CustomAttributesHeader.unwrap(value): java.lang.String
        )
      )(_.customAttributes)
      .optionallyWith(
        targetModel.map(value =>
          TargetModelHeader.unwrap(value): java.lang.String
        )
      )(_.targetModel)
      .optionallyWith(
        targetVariant.map(value =>
          TargetVariantHeader.unwrap(value): java.lang.String
        )
      )(_.targetVariant)
      .optionallyWith(
        targetContainerHostname.map(value =>
          TargetContainerHostnameHeader.unwrap(value): java.lang.String
        )
      )(_.targetContainerHostname)
      .optionallyWith(
        inferenceId.map(value => InferenceId.unwrap(value): java.lang.String)
      )(_.inferenceId)
      .optionallyWith(
        enableExplanations.map(value =>
          EnableExplanationsHeader.unwrap(value): java.lang.String
        )
      )(_.enableExplanations)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerruntime.model.InvokeEndpointRequest.ReadOnly =
    zio.aws.sagemakerruntime.model.InvokeEndpointRequest.wrap(buildAwsValue())
}
object InvokeEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakerruntime.model.InvokeEndpointRequest =
      zio.aws.sagemakerruntime.model.InvokeEndpointRequest(
        endpointName,
        body,
        contentType.map(value => value),
        accept.map(value => value),
        customAttributes.map(value => value),
        targetModel.map(value => value),
        targetVariant.map(value => value),
        targetContainerHostname.map(value => value),
        inferenceId.map(value => value),
        enableExplanations.map(value => value)
      )
    def endpointName: EndpointName
    def body: BodyBlob
    def contentType: Optional[Header]
    def accept: Optional[Header]
    def customAttributes: Optional[CustomAttributesHeader]
    def targetModel: Optional[TargetModelHeader]
    def targetVariant: Optional[TargetVariantHeader]
    def targetContainerHostname: Optional[TargetContainerHostnameHeader]
    def inferenceId: Optional[InferenceId]
    def enableExplanations: Optional[EnableExplanationsHeader]
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getBody: ZIO[Any, Nothing, BodyBlob] = ZIO.succeed(body)
    def getContentType: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getAccept: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("accept", accept)
    def getCustomAttributes: ZIO[Any, AwsError, CustomAttributesHeader] =
      AwsError.unwrapOptionField("customAttributes", customAttributes)
    def getTargetModel: ZIO[Any, AwsError, TargetModelHeader] =
      AwsError.unwrapOptionField("targetModel", targetModel)
    def getTargetVariant: ZIO[Any, AwsError, TargetVariantHeader] =
      AwsError.unwrapOptionField("targetVariant", targetVariant)
    def getTargetContainerHostname
        : ZIO[Any, AwsError, TargetContainerHostnameHeader] = AwsError
      .unwrapOptionField("targetContainerHostname", targetContainerHostname)
    def getInferenceId: ZIO[Any, AwsError, InferenceId] =
      AwsError.unwrapOptionField("inferenceId", inferenceId)
    def getEnableExplanations: ZIO[Any, AwsError, EnableExplanationsHeader] =
      AwsError.unwrapOptionField("enableExplanations", enableExplanations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointRequest
  ) extends zio.aws.sagemakerruntime.model.InvokeEndpointRequest.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemakerruntime.model.primitives
        .EndpointName(impl.endpointName())
    override val body: BodyBlob = zio.aws.sagemakerruntime.model.primitives
      .BodyBlob(zio.Chunk.fromArray(impl.body().asByteArrayUnsafe()))
    override val contentType: Optional[Header] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
    override val accept: Optional[Header] = zio.aws.core.internal
      .optionalFromNullable(impl.accept())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
    override val customAttributes: Optional[CustomAttributesHeader] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAttributes())
        .map(value =>
          zio.aws.sagemakerruntime.model.primitives
            .CustomAttributesHeader(value)
        )
    override val targetModel: Optional[TargetModelHeader] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetModel())
        .map(value =>
          zio.aws.sagemakerruntime.model.primitives.TargetModelHeader(value)
        )
    override val targetVariant: Optional[TargetVariantHeader] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetVariant())
        .map(value =>
          zio.aws.sagemakerruntime.model.primitives.TargetVariantHeader(value)
        )
    override val targetContainerHostname
        : Optional[TargetContainerHostnameHeader] = zio.aws.core.internal
      .optionalFromNullable(impl.targetContainerHostname())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives
          .TargetContainerHostnameHeader(value)
      )
    override val inferenceId: Optional[InferenceId] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceId())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives.InferenceId(value)
      )
    override val enableExplanations: Optional[EnableExplanationsHeader] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableExplanations())
        .map(value =>
          zio.aws.sagemakerruntime.model.primitives
            .EnableExplanationsHeader(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointRequest
  ): zio.aws.sagemakerruntime.model.InvokeEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
