package zio.aws.sagemakerruntime.model
import zio.aws.sagemakerruntime.model.primitives.{
  InferenceId,
  EndpointName,
  InputLocationHeader,
  RequestTTLSecondsHeader,
  CustomAttributesHeader,
  Header
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class InvokeEndpointAsyncRequest(
    endpointName: EndpointName,
    contentType: Optional[Header] = Optional.Absent,
    accept: Optional[Header] = Optional.Absent,
    customAttributes: Optional[CustomAttributesHeader] = Optional.Absent,
    inferenceId: Optional[InferenceId] = Optional.Absent,
    inputLocation: InputLocationHeader,
    requestTTLSeconds: Optional[RequestTTLSecondsHeader] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncRequest = {
    import InvokeEndpointAsyncRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncRequest
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .optionallyWith(
        contentType.map(value => Header.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        accept.map(value => Header.unwrap(value): java.lang.String)
      )(_.accept)
      .optionallyWith(
        customAttributes.map(value =>
          CustomAttributesHeader.unwrap(value): java.lang.String
        )
      )(_.customAttributes)
      .optionallyWith(
        inferenceId.map(value => InferenceId.unwrap(value): java.lang.String)
      )(_.inferenceId)
      .inputLocation(
        InputLocationHeader.unwrap(inputLocation): java.lang.String
      )
      .optionallyWith(
        requestTTLSeconds.map(value =>
          RequestTTLSecondsHeader.unwrap(value): Integer
        )
      )(_.requestTTLSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest.ReadOnly =
    zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest
      .wrap(buildAwsValue())
}
object InvokeEndpointAsyncRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest =
      zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest(
        endpointName,
        contentType.map(value => value),
        accept.map(value => value),
        customAttributes.map(value => value),
        inferenceId.map(value => value),
        inputLocation,
        requestTTLSeconds.map(value => value)
      )
    def endpointName: EndpointName
    def contentType: Optional[Header]
    def accept: Optional[Header]
    def customAttributes: Optional[CustomAttributesHeader]
    def inferenceId: Optional[InferenceId]
    def inputLocation: InputLocationHeader
    def requestTTLSeconds: Optional[RequestTTLSecondsHeader]
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getContentType: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getAccept: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("accept", accept)
    def getCustomAttributes: ZIO[Any, AwsError, CustomAttributesHeader] =
      AwsError.unwrapOptionField("customAttributes", customAttributes)
    def getInferenceId: ZIO[Any, AwsError, InferenceId] =
      AwsError.unwrapOptionField("inferenceId", inferenceId)
    def getInputLocation: ZIO[Any, Nothing, InputLocationHeader] =
      ZIO.succeed(inputLocation)
    def getRequestTTLSeconds: ZIO[Any, AwsError, RequestTTLSecondsHeader] =
      AwsError.unwrapOptionField("requestTTLSeconds", requestTTLSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncRequest
  ) extends zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemakerruntime.model.primitives
        .EndpointName(impl.endpointName())
    override val contentType: Optional[Header] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
    override val accept: Optional[Header] = zio.aws.core.internal
      .optionalFromNullable(impl.accept())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
    override val customAttributes: Optional[CustomAttributesHeader] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAttributes())
        .map(value =>
          zio.aws.sagemakerruntime.model.primitives
            .CustomAttributesHeader(value)
        )
    override val inferenceId: Optional[InferenceId] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceId())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives.InferenceId(value)
      )
    override val inputLocation: InputLocationHeader =
      zio.aws.sagemakerruntime.model.primitives
        .InputLocationHeader(impl.inputLocation())
    override val requestTTLSeconds: Optional[RequestTTLSecondsHeader] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestTTLSeconds())
        .map(value =>
          zio.aws.sagemakerruntime.model.primitives
            .RequestTTLSecondsHeader(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncRequest
  ): zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest.ReadOnly =
    new Wrapper(impl)
}
