package zio.aws.sagemakerruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakerruntime.model.primitives.Header
import scala.jdk.CollectionConverters.*
final case class InvokeEndpointAsyncResponse(
    inferenceId: Optional[Header] = Optional.Absent,
    outputLocation: Optional[Header] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncResponse = {
    import InvokeEndpointAsyncResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncResponse
      .builder()
      .optionallyWith(
        inferenceId.map(value => Header.unwrap(value): java.lang.String)
      )(_.inferenceId)
      .optionallyWith(
        outputLocation.map(value => Header.unwrap(value): java.lang.String)
      )(_.outputLocation)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly =
    zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse
      .wrap(buildAwsValue())
}
object InvokeEndpointAsyncResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse =
      zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse(
        inferenceId.map(value => value),
        outputLocation.map(value => value)
      )
    def inferenceId: Optional[Header]
    def outputLocation: Optional[Header]
    def getInferenceId: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("inferenceId", inferenceId)
    def getOutputLocation: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncResponse
  ) extends zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly {
    override val inferenceId: Optional[Header] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceId())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
    override val outputLocation: Optional[Header] = zio.aws.core.internal
      .optionalFromNullable(impl.outputLocation())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncResponse
  ): zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly =
    new Wrapper(impl)
}
