package zio.aws.sagemakerruntime.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemakerruntime.model.primitives.{
  InferenceId,
  EndpointName,
  InputLocationHeader,
  RequestTTLSecondsHeader,
  CustomAttributesHeader,
  Header
}
import scala.jdk.CollectionConverters.*
final case class InvokeEndpointAsyncRequest(
    endpointName: EndpointName,
    contentType: Option[Header] = None,
    accept: Option[Header] = None,
    customAttributes: Option[CustomAttributesHeader] = None,
    inferenceId: Option[InferenceId] = None,
    inputLocation: InputLocationHeader,
    requestTTLSeconds: Option[RequestTTLSecondsHeader] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncRequest = {
    import InvokeEndpointAsyncRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncRequest
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .optionallyWith(
        contentType.map(value => Header.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        accept.map(value => Header.unwrap(value): java.lang.String)
      )(_.accept)
      .optionallyWith(
        customAttributes.map(value =>
          CustomAttributesHeader.unwrap(value): java.lang.String
        )
      )(_.customAttributes)
      .optionallyWith(
        inferenceId.map(value => InferenceId.unwrap(value): java.lang.String)
      )(_.inferenceId)
      .inputLocation(
        InputLocationHeader.unwrap(inputLocation): java.lang.String
      )
      .optionallyWith(
        requestTTLSeconds.map(value =>
          RequestTTLSecondsHeader.unwrap(value): Integer
        )
      )(_.requestTTLSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest.ReadOnly =
    zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest
      .wrap(buildAwsValue())
}
object InvokeEndpointAsyncRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest =
      zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest(
        endpointName,
        contentType.map(value => value),
        accept.map(value => value),
        customAttributes.map(value => value),
        inferenceId.map(value => value),
        inputLocation,
        requestTTLSeconds.map(value => value)
      )
    def endpointName: EndpointName
    def contentType: Option[Header]
    def accept: Option[Header]
    def customAttributes: Option[CustomAttributesHeader]
    def inferenceId: Option[InferenceId]
    def inputLocation: InputLocationHeader
    def requestTTLSeconds: Option[RequestTTLSecondsHeader]
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getContentType: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getAccept: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("accept", accept)
    def getCustomAttributes: ZIO[Any, AwsError, CustomAttributesHeader] =
      AwsError.unwrapOptionField("customAttributes", customAttributes)
    def getInferenceId: ZIO[Any, AwsError, InferenceId] =
      AwsError.unwrapOptionField("inferenceId", inferenceId)
    def getInputLocation: ZIO[Any, Nothing, InputLocationHeader] =
      ZIO.succeed(inputLocation)
    def getRequestTTLSeconds: ZIO[Any, AwsError, RequestTTLSecondsHeader] =
      AwsError.unwrapOptionField("requestTTLSeconds", requestTTLSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncRequest
  ) extends zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemakerruntime.model.primitives
        .EndpointName(impl.endpointName())
    override val contentType: Option[Header] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
    override val accept: Option[Header] = scala
      .Option(impl.accept())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
    override val customAttributes: Option[CustomAttributesHeader] = scala
      .Option(impl.customAttributes())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives.CustomAttributesHeader(value)
      )
    override val inferenceId: Option[InferenceId] = scala
      .Option(impl.inferenceId())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives.InferenceId(value)
      )
    override val inputLocation: InputLocationHeader =
      zio.aws.sagemakerruntime.model.primitives
        .InputLocationHeader(impl.inputLocation())
    override val requestTTLSeconds: Option[RequestTTLSecondsHeader] = scala
      .Option(impl.requestTTLSeconds())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives.RequestTTLSecondsHeader(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncRequest
  ): zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest.ReadOnly =
    new Wrapper(impl)
}
