package zio.aws.sagemakerruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemakerruntime.model.primitives.Header
import scala.jdk.CollectionConverters.*
final case class InvokeEndpointAsyncResponse(
    inferenceId: Option[Header] = None,
    outputLocation: Option[Header] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncResponse = {
    import InvokeEndpointAsyncResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncResponse
      .builder()
      .optionallyWith(
        inferenceId.map(value => Header.unwrap(value): java.lang.String)
      )(_.inferenceId)
      .optionallyWith(
        outputLocation.map(value => Header.unwrap(value): java.lang.String)
      )(_.outputLocation)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly =
    zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse
      .wrap(buildAwsValue())
}
object InvokeEndpointAsyncResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse =
      zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse(
        inferenceId.map(value => value),
        outputLocation.map(value => value)
      )
    def inferenceId: Option[Header]
    def outputLocation: Option[Header]
    def getInferenceId: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("inferenceId", inferenceId)
    def getOutputLocation: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncResponse
  ) extends zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly {
    override val inferenceId: Option[Header] = scala
      .Option(impl.inferenceId())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
    override val outputLocation: Option[Header] = scala
      .Option(impl.outputLocation())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointAsyncResponse
  ): zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly =
    new Wrapper(impl)
}
