package zio.aws.sagemakerruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemakerruntime.model.primitives.{
  TargetVariantHeader,
  InferenceId,
  EndpointName,
  TargetModelHeader,
  TargetContainerHostnameHeader,
  CustomAttributesHeader,
  BodyBlob,
  Header
}
import scala.jdk.CollectionConverters.*
final case class InvokeEndpointRequest(
    endpointName: EndpointName,
    body: BodyBlob,
    contentType: Option[Header] = None,
    accept: Option[Header] = None,
    customAttributes: Option[CustomAttributesHeader] = None,
    targetModel: Option[TargetModelHeader] = None,
    targetVariant: Option[TargetVariantHeader] = None,
    targetContainerHostname: Option[TargetContainerHostnameHeader] = None,
    inferenceId: Option[InferenceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointRequest = {
    import InvokeEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointRequest
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .body(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          body.toArray[Byte]
        )
      )
      .optionallyWith(
        contentType.map(value => Header.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        accept.map(value => Header.unwrap(value): java.lang.String)
      )(_.accept)
      .optionallyWith(
        customAttributes.map(value =>
          CustomAttributesHeader.unwrap(value): java.lang.String
        )
      )(_.customAttributes)
      .optionallyWith(
        targetModel.map(value =>
          TargetModelHeader.unwrap(value): java.lang.String
        )
      )(_.targetModel)
      .optionallyWith(
        targetVariant.map(value =>
          TargetVariantHeader.unwrap(value): java.lang.String
        )
      )(_.targetVariant)
      .optionallyWith(
        targetContainerHostname.map(value =>
          TargetContainerHostnameHeader.unwrap(value): java.lang.String
        )
      )(_.targetContainerHostname)
      .optionallyWith(
        inferenceId.map(value => InferenceId.unwrap(value): java.lang.String)
      )(_.inferenceId)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerruntime.model.InvokeEndpointRequest.ReadOnly =
    zio.aws.sagemakerruntime.model.InvokeEndpointRequest.wrap(buildAwsValue())
}
object InvokeEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakerruntime.model.InvokeEndpointRequest =
      zio.aws.sagemakerruntime.model.InvokeEndpointRequest(
        endpointName,
        body,
        contentType.map(value => value),
        accept.map(value => value),
        customAttributes.map(value => value),
        targetModel.map(value => value),
        targetVariant.map(value => value),
        targetContainerHostname.map(value => value),
        inferenceId.map(value => value)
      )
    def endpointName: EndpointName
    def body: BodyBlob
    def contentType: Option[Header]
    def accept: Option[Header]
    def customAttributes: Option[CustomAttributesHeader]
    def targetModel: Option[TargetModelHeader]
    def targetVariant: Option[TargetVariantHeader]
    def targetContainerHostname: Option[TargetContainerHostnameHeader]
    def inferenceId: Option[InferenceId]
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getBody: ZIO[Any, Nothing, BodyBlob] = ZIO.succeed(body)
    def getContentType: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getAccept: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("accept", accept)
    def getCustomAttributes: ZIO[Any, AwsError, CustomAttributesHeader] =
      AwsError.unwrapOptionField("customAttributes", customAttributes)
    def getTargetModel: ZIO[Any, AwsError, TargetModelHeader] =
      AwsError.unwrapOptionField("targetModel", targetModel)
    def getTargetVariant: ZIO[Any, AwsError, TargetVariantHeader] =
      AwsError.unwrapOptionField("targetVariant", targetVariant)
    def getTargetContainerHostname
        : ZIO[Any, AwsError, TargetContainerHostnameHeader] = AwsError
      .unwrapOptionField("targetContainerHostname", targetContainerHostname)
    def getInferenceId: ZIO[Any, AwsError, InferenceId] =
      AwsError.unwrapOptionField("inferenceId", inferenceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointRequest
  ) extends zio.aws.sagemakerruntime.model.InvokeEndpointRequest.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemakerruntime.model.primitives
        .EndpointName(impl.endpointName())
    override val body: BodyBlob = zio.aws.sagemakerruntime.model.primitives
      .BodyBlob(zio.Chunk.fromArray(impl.body().asByteArrayUnsafe()))
    override val contentType: Option[Header] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
    override val accept: Option[Header] = scala
      .Option(impl.accept())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
    override val customAttributes: Option[CustomAttributesHeader] = scala
      .Option(impl.customAttributes())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives.CustomAttributesHeader(value)
      )
    override val targetModel: Option[TargetModelHeader] = scala
      .Option(impl.targetModel())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives.TargetModelHeader(value)
      )
    override val targetVariant: Option[TargetVariantHeader] = scala
      .Option(impl.targetVariant())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives.TargetVariantHeader(value)
      )
    override val targetContainerHostname
        : Option[TargetContainerHostnameHeader] = scala
      .Option(impl.targetContainerHostname())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives
          .TargetContainerHostnameHeader(value)
      )
    override val inferenceId: Option[InferenceId] = scala
      .Option(impl.inferenceId())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives.InferenceId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointRequest
  ): zio.aws.sagemakerruntime.model.InvokeEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
