package zio.aws.sagemakerruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemakerruntime.model.primitives.{
  CustomAttributesHeader,
  Header,
  BodyBlob
}
import scala.jdk.CollectionConverters.*
final case class InvokeEndpointResponse(
    body: BodyBlob,
    contentType: Option[Header] = None,
    invokedProductionVariant: Option[Header] = None,
    customAttributes: Option[CustomAttributesHeader] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointResponse = {
    import InvokeEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointResponse
      .builder()
      .body(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(body.toArray[Byte])
      )
      .optionallyWith(
        contentType.map(value => Header.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        invokedProductionVariant.map(value =>
          Header.unwrap(value): java.lang.String
        )
      )(_.invokedProductionVariant)
      .optionallyWith(
        customAttributes.map(value =>
          CustomAttributesHeader.unwrap(value): java.lang.String
        )
      )(_.customAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerruntime.model.InvokeEndpointResponse.ReadOnly =
    zio.aws.sagemakerruntime.model.InvokeEndpointResponse.wrap(buildAwsValue())
}
object InvokeEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakerruntime.model.InvokeEndpointResponse =
      zio.aws.sagemakerruntime.model.InvokeEndpointResponse(
        body,
        contentType.map(value => value),
        invokedProductionVariant.map(value => value),
        customAttributes.map(value => value)
      )
    def body: BodyBlob
    def contentType: Option[Header]
    def invokedProductionVariant: Option[Header]
    def customAttributes: Option[CustomAttributesHeader]
    def getBody: ZIO[Any, Nothing, BodyBlob] = ZIO.succeed(body)
    def getContentType: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getInvokedProductionVariant: ZIO[Any, AwsError, Header] = AwsError
      .unwrapOptionField("invokedProductionVariant", invokedProductionVariant)
    def getCustomAttributes: ZIO[Any, AwsError, CustomAttributesHeader] =
      AwsError.unwrapOptionField("customAttributes", customAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointResponse
  ) extends zio.aws.sagemakerruntime.model.InvokeEndpointResponse.ReadOnly {
    override val body: BodyBlob = zio.aws.sagemakerruntime.model.primitives
      .BodyBlob(zio.Chunk.fromArray(impl.body().asByteArrayUnsafe()))
    override val contentType: Option[Header] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
    override val invokedProductionVariant: Option[Header] = scala
      .Option(impl.invokedProductionVariant())
      .map(value => zio.aws.sagemakerruntime.model.primitives.Header(value))
    override val customAttributes: Option[CustomAttributesHeader] = scala
      .Option(impl.customAttributes())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives.CustomAttributesHeader(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointResponse
  ): zio.aws.sagemakerruntime.model.InvokeEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
