package zio.aws.sagemakerruntime
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.sagemakerruntime.model.{
  InvokeEndpointWithResponseStreamResponseHandler,
  InvokeEndpointRequest,
  InvokeEndpointWithResponseStreamResponse,
  InvokeEndpointAsyncRequest,
  InvokeEndpointResponse,
  InvokeEndpointAsyncResponse,
  ResponseStream,
  InvokeEndpointWithResponseStreamRequest,
  PayloadPart
}
import software.amazon.awssdk.services.sagemakerruntime.{
  SageMakerRuntimeAsyncClientBuilder,
  SageMakerRuntimeAsyncClient
}
import software.amazon.awssdk.core.async.SdkPublisher
import zio.aws.sagemakerruntime.model.InvokeEndpointResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait SageMakerRuntime extends AspectSupport[SageMakerRuntime] {
  val api: SageMakerRuntimeAsyncClient
  def invokeEndpoint(
      request: zio.aws.sagemakerruntime.model.InvokeEndpointRequest
  ): IO[AwsError, ReadOnly]
  def invokeEndpointAsync(
      request: zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest
  ): IO[
    AwsError,
    zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly
  ]
  def invokeEndpointWithResponseStream(
      request: zio.aws.sagemakerruntime.model.InvokeEndpointWithResponseStreamRequest
  ): ZStream[Any, AwsError, zio.aws.sagemakerruntime.model.PayloadPart.ReadOnly]
}
object SageMakerRuntime {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SageMakerRuntime] =
    customized(identity)
  def customized(
      customization: SageMakerRuntimeAsyncClientBuilder => SageMakerRuntimeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SageMakerRuntime] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SageMakerRuntimeAsyncClientBuilder => SageMakerRuntimeAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, SageMakerRuntime] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SageMakerRuntimeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      SageMakerRuntimeAsyncClient,
      SageMakerRuntimeAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      SageMakerRuntimeAsyncClient,
      SageMakerRuntimeAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new SageMakerRuntimeImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class SageMakerRuntimeImpl[R](
      override val api: SageMakerRuntimeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SageMakerRuntime
      with AwsServiceBase[R] {
    override val serviceName: String = "SageMakerRuntime"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SageMakerRuntimeImpl[R1] = new SageMakerRuntimeImpl(api, newAspect, r)
    def invokeEndpoint(
        request: zio.aws.sagemakerruntime.model.InvokeEndpointRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[InvokeEndpointRequest, InvokeEndpointResponse](
        "invokeEndpoint",
        api.invokeEndpoint
      )(request.buildAwsValue())
        .map(zio.aws.sagemakerruntime.model.InvokeEndpointResponse.wrap)
        .provideEnvironment(r)
    def invokeEndpointAsync(
        request: zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest
    ): IO[
      AwsError,
      zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly
    ] = asyncRequestResponse[
      InvokeEndpointAsyncRequest,
      InvokeEndpointAsyncResponse
    ]("invokeEndpointAsync", api.invokeEndpointAsync)(request.buildAwsValue())
      .map(zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.wrap)
      .provideEnvironment(r)
    def invokeEndpointWithResponseStream(
        request: zio.aws.sagemakerruntime.model.InvokeEndpointWithResponseStreamRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemakerruntime.model.PayloadPart.ReadOnly
    ] = asyncRequestEventOutputStream[
      InvokeEndpointWithResponseStreamRequest,
      InvokeEndpointWithResponseStreamResponse,
      InvokeEndpointWithResponseStreamResponseHandler,
      ResponseStream,
      PayloadPart
    ](
      "InvokeEndpointWithResponseStream",
      (
          request: InvokeEndpointWithResponseStreamRequest,
          handler: InvokeEndpointWithResponseStreamResponseHandler
      ) => api.invokeEndpointWithResponseStream(request, handler),
      (impl: EventStreamResponseHandler[
        InvokeEndpointWithResponseStreamResponse,
        ResponseStream
      ]) =>
        new InvokeEndpointWithResponseStreamResponseHandler {
          override def responseReceived(
              response: InvokeEndpointWithResponseStreamResponse
          ): Unit = impl.responseReceived(response)
          override def onEventStream(
              publisher: SdkPublisher[ResponseStream]
          ): Unit = impl.onEventStream(publisher)
          override def exceptionOccurred(throwable: java.lang.Throwable): Unit =
            impl.exceptionOccurred(throwable)
          override def complete(): Unit = impl.complete()
        }
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemakerruntime.model.PayloadPart.wrap(item))
      .provideEnvironment(r)
  }
  def invokeEndpoint(
      request: zio.aws.sagemakerruntime.model.InvokeEndpointRequest
  ): ZIO[zio.aws.sagemakerruntime.SageMakerRuntime, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.invokeEndpoint(request))
  def invokeEndpointAsync(
      request: zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest
  ): ZIO[
    zio.aws.sagemakerruntime.SageMakerRuntime,
    AwsError,
    zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.invokeEndpointAsync(request))
  def invokeEndpointWithResponseStream(
      request: zio.aws.sagemakerruntime.model.InvokeEndpointWithResponseStreamRequest
  ): ZStream[
    zio.aws.sagemakerruntime.SageMakerRuntime,
    AwsError,
    zio.aws.sagemakerruntime.model.PayloadPart.ReadOnly
  ] = ZStream.serviceWithStream(_.invokeEndpointWithResponseStream(request))
}
