package zio.aws.sagemakerruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakerruntime.model.primitives.PartBlob
import scala.jdk.CollectionConverters._
final case class PayloadPart(bytes: Optional[PartBlob] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerruntime.model.PayloadPart = {
    import PayloadPart.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerruntime.model.PayloadPart
      .builder()
      .optionallyWith(
        bytes.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.bytes)
      .build()
  }
  def asReadOnly: zio.aws.sagemakerruntime.model.PayloadPart.ReadOnly =
    zio.aws.sagemakerruntime.model.PayloadPart.wrap(buildAwsValue())
}
object PayloadPart {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerruntime.model.PayloadPart
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakerruntime.model.PayloadPart =
      zio.aws.sagemakerruntime.model.PayloadPart(bytes.map(value => value))
    def bytes: Optional[PartBlob]
    def getBytes: ZIO[Any, AwsError, PartBlob] =
      AwsError.unwrapOptionField("bytes", bytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.PayloadPart
  ) extends zio.aws.sagemakerruntime.model.PayloadPart.ReadOnly {
    override val bytes: Optional[PartBlob] = zio.aws.core.internal
      .optionalFromNullable(impl.bytes())
      .map(value =>
        zio.aws.sagemakerruntime.model.primitives
          .PartBlob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerruntime.model.PayloadPart
  ): zio.aws.sagemakerruntime.model.PayloadPart.ReadOnly = new Wrapper(impl)
}
