package zio.aws.sagemakerruntime
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.sagemakerruntime.SageMakerRuntimeAsyncClient
import zio.aws.sagemakerruntime.model.InvokeEndpointResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.sagemakerruntime.model.{
  InvokeEndpointWithResponseStreamRequest,
  InvokeEndpointAsyncRequest,
  InvokeEndpointRequest
}
import zio.stream.ZStream
object SageMakerRuntimeMock extends Mock[SageMakerRuntime] {
  object InvokeEndpoint
      extends Effect[InvokeEndpointRequest, AwsError, ReadOnly]
  object InvokeEndpointAsync
      extends Effect[
        InvokeEndpointAsyncRequest,
        AwsError,
        zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly
      ]
  object InvokeEndpointWithResponseStream
      extends Stream[
        InvokeEndpointWithResponseStreamRequest,
        AwsError,
        zio.aws.sagemakerruntime.model.PayloadPart.ReadOnly
      ]
  val compose: URLayer[Proxy, SageMakerRuntime] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, SageMakerRuntime] { rts =>
        zio.ZIO.succeed {
          new SageMakerRuntime {
            val api: SageMakerRuntimeAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): SageMakerRuntime = this
            def invokeEndpoint(
                request: InvokeEndpointRequest
            ): IO[AwsError, ReadOnly] = proxy(InvokeEndpoint, request)
            def invokeEndpointAsync(request: InvokeEndpointAsyncRequest): IO[
              AwsError,
              zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly
            ] = proxy(InvokeEndpointAsync, request)
            def invokeEndpointWithResponseStream(
                request: InvokeEndpointWithResponseStreamRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemakerruntime.model.PayloadPart.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(InvokeEndpointWithResponseStream, request)
                }
                .getOrThrowFiberFailure()
            }
          }
        }
      }
    }
  }
}
