package zio.aws.sagemakerruntime
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.sagemakerruntime.SageMakerRuntimeAsyncClient
import zio.aws.sagemakerruntime.model.InvokeEndpointResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.sagemakerruntime.model.{
  InvokeEndpointAsyncRequest,
  InvokeEndpointRequest
}
object SageMakerRuntimeMock extends Mock[SageMakerRuntime] {
  object InvokeEndpoint
      extends Effect[InvokeEndpointRequest, AwsError, ReadOnly]
  object InvokeEndpointAsync
      extends Effect[
        InvokeEndpointAsyncRequest,
        AwsError,
        zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SageMakerRuntime] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new SageMakerRuntime {
          val api: SageMakerRuntimeAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : SageMakerRuntime = this
          def invokeEndpoint(
              request: InvokeEndpointRequest
          ): IO[AwsError, ReadOnly] = proxy(InvokeEndpoint, request)
          def invokeEndpointAsync(request: InvokeEndpointAsyncRequest): IO[
            AwsError,
            zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly
          ] = proxy(InvokeEndpointAsync, request)
        }
      }
    }
  }
}
