package zio.aws.sagemakerruntime
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.sagemakerruntime.model.{
  InvokeEndpointAsyncResponse,
  InvokeEndpointAsyncRequest,
  InvokeEndpointResponse,
  InvokeEndpointRequest
}
import software.amazon.awssdk.services.sagemakerruntime.{
  SageMakerRuntimeAsyncClientBuilder,
  SageMakerRuntimeAsyncClient
}
import zio.aws.sagemakerruntime.model.InvokeEndpointResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import scala.jdk.CollectionConverters._
trait SageMakerRuntime extends AspectSupport[SageMakerRuntime] {
  val api: SageMakerRuntimeAsyncClient
  def invokeEndpoint(
      request: zio.aws.sagemakerruntime.model.InvokeEndpointRequest
  ): IO[AwsError, ReadOnly]
  def invokeEndpointAsync(
      request: zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest
  ): IO[
    AwsError,
    zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly
  ]
}
object SageMakerRuntime {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SageMakerRuntime] =
    customized(identity)
  def customized(
      customization: SageMakerRuntimeAsyncClientBuilder => SageMakerRuntimeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SageMakerRuntime] = managed(
    customization
  ).toLayer
  def managed(
      customization: SageMakerRuntimeAsyncClientBuilder => SageMakerRuntimeAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, SageMakerRuntime] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = SageMakerRuntimeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        SageMakerRuntimeAsyncClient,
        SageMakerRuntimeAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        SageMakerRuntimeAsyncClient,
        SageMakerRuntimeAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new SageMakerRuntimeImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class SageMakerRuntimeImpl[R](
      override val api: SageMakerRuntimeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SageMakerRuntime
      with AwsServiceBase[R] {
    override val serviceName: String = "SageMakerRuntime"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SageMakerRuntimeImpl[R1] = new SageMakerRuntimeImpl(api, newAspect, r)
    def invokeEndpoint(
        request: zio.aws.sagemakerruntime.model.InvokeEndpointRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[InvokeEndpointRequest, InvokeEndpointResponse](
        "invokeEndpoint",
        api.invokeEndpoint
      )(request.buildAwsValue())
        .map(zio.aws.sagemakerruntime.model.InvokeEndpointResponse.wrap)
        .provideEnvironment(r)
    def invokeEndpointAsync(
        request: zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest
    ): IO[
      AwsError,
      zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly
    ] = asyncRequestResponse[
      InvokeEndpointAsyncRequest,
      InvokeEndpointAsyncResponse
    ]("invokeEndpointAsync", api.invokeEndpointAsync)(request.buildAwsValue())
      .map(zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.wrap)
      .provideEnvironment(r)
  }
  def invokeEndpoint(
      request: zio.aws.sagemakerruntime.model.InvokeEndpointRequest
  ): ZIO[zio.aws.sagemakerruntime.SageMakerRuntime, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.invokeEndpoint(request))
  def invokeEndpointAsync(
      request: zio.aws.sagemakerruntime.model.InvokeEndpointAsyncRequest
  ): ZIO[
    zio.aws.sagemakerruntime.SageMakerRuntime,
    AwsError,
    zio.aws.sagemakerruntime.model.InvokeEndpointAsyncResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.invokeEndpointAsync(request))
}
