package zio.aws.sagemakermetrics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemakermetrics.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters.*
final case class BatchPutMetricsRequest(
    trialComponentName: ExperimentEntityName,
    metricData: Iterable[zio.aws.sagemakermetrics.model.RawMetricData]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsRequest = {
    import BatchPutMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsRequest
      .builder()
      .trialComponentName(
        ExperimentEntityName.unwrap(trialComponentName): java.lang.String
      )
      .metricData(metricData.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakermetrics.model.BatchPutMetricsRequest.ReadOnly =
    zio.aws.sagemakermetrics.model.BatchPutMetricsRequest.wrap(buildAwsValue())
}
object BatchPutMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakermetrics.model.BatchPutMetricsRequest =
      zio.aws.sagemakermetrics.model.BatchPutMetricsRequest(
        trialComponentName,
        metricData.map { item =>
          item.asEditable
        }
      )
    def trialComponentName: ExperimentEntityName
    def metricData: List[zio.aws.sagemakermetrics.model.RawMetricData.ReadOnly]
    def getTrialComponentName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialComponentName)
    def getMetricData: ZIO[Any, Nothing, List[
      zio.aws.sagemakermetrics.model.RawMetricData.ReadOnly
    ]] = ZIO.succeed(metricData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsRequest
  ) extends zio.aws.sagemakermetrics.model.BatchPutMetricsRequest.ReadOnly {
    override val trialComponentName: ExperimentEntityName =
      zio.aws.sagemakermetrics.model.primitives
        .ExperimentEntityName(impl.trialComponentName())
    override val metricData
        : List[zio.aws.sagemakermetrics.model.RawMetricData.ReadOnly] = impl
      .metricData()
      .asScala
      .map { item =>
        zio.aws.sagemakermetrics.model.RawMetricData.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsRequest
  ): zio.aws.sagemakermetrics.model.BatchPutMetricsRequest.ReadOnly =
    new Wrapper(impl)
}
