package zio.aws.sagemakermetrics.model
import scala.jdk.CollectionConverters.*
sealed trait PutMetricsErrorCode {
  def unwrap: software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode
}
object PutMetricsErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode
  ): zio.aws.sagemakermetrics.model.PutMetricsErrorCode = value match {
    case software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode.METRIC_LIMIT_EXCEEDED =>
      val r = METRIC_LIMIT_EXCEEDED
      r
    case software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode.VALIDATION_ERROR =>
      val r = VALIDATION_ERROR
      r
    case software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode.CONFLICT_ERROR =>
      val r = CONFLICT_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemakermetrics.model.PutMetricsErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode =
      software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object METRIC_LIMIT_EXCEEDED
      extends zio.aws.sagemakermetrics.model.PutMetricsErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode =
      software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode.METRIC_LIMIT_EXCEEDED
  }
  case object INTERNAL_ERROR
      extends zio.aws.sagemakermetrics.model.PutMetricsErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode =
      software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode.INTERNAL_ERROR
  }
  case object VALIDATION_ERROR
      extends zio.aws.sagemakermetrics.model.PutMetricsErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode =
      software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode.VALIDATION_ERROR
  }
  case object CONFLICT_ERROR
      extends zio.aws.sagemakermetrics.model.PutMetricsErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode =
      software.amazon.awssdk.services.sagemakermetrics.model.PutMetricsErrorCode.CONFLICT_ERROR
  }
}
