package zio.aws.sagemakermetrics
import zio.aws.core.config.AwsConfig
import zio.aws.sagemakermetrics.model.BatchPutMetricsRequest
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.sagemakermetrics.model.BatchPutMetricsResponse.ReadOnly
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.sagemakermetrics.{
  SageMakerMetricsAsyncClientBuilder,
  SageMakerMetricsAsyncClient
}
import software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsResponse
import scala.jdk.CollectionConverters._
trait SageMakerMetrics extends AspectSupport[SageMakerMetrics] {
  val api: SageMakerMetricsAsyncClient
  def batchPutMetrics(request: BatchPutMetricsRequest): IO[AwsError, ReadOnly]
}
object SageMakerMetrics {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SageMakerMetrics] =
    customized(identity)
  def customized(
      customization: SageMakerMetricsAsyncClientBuilder => SageMakerMetricsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SageMakerMetrics] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SageMakerMetricsAsyncClientBuilder => SageMakerMetricsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, SageMakerMetrics] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SageMakerMetricsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      SageMakerMetricsAsyncClient,
      SageMakerMetricsAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      SageMakerMetricsAsyncClient,
      SageMakerMetricsAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new SageMakerMetricsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class SageMakerMetricsImpl[R](
      override val api: SageMakerMetricsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SageMakerMetrics
      with AwsServiceBase[R] {
    override val serviceName: String = "SageMakerMetrics"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SageMakerMetricsImpl[R1] = new SageMakerMetricsImpl(api, newAspect, r)
    def batchPutMetrics(
        request: BatchPutMetricsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsRequest,
      BatchPutMetricsResponse
    ]("batchPutMetrics", api.batchPutMetrics)(request.buildAwsValue())
      .map(zio.aws.sagemakermetrics.model.BatchPutMetricsResponse.wrap)
      .provideEnvironment(r)
  }
  def batchPutMetrics(
      request: BatchPutMetricsRequest
  ): ZIO[zio.aws.sagemakermetrics.SageMakerMetrics, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.batchPutMetrics(request))
}
