package zio.aws.sagemakermetrics.model
import zio.aws.sagemakermetrics.model.primitives.{Step, Timestamp, MetricName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RawMetricData(
    metricName: MetricName,
    timestamp: Timestamp,
    step: Optional[Step] = Optional.Absent,
    value: Double
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakermetrics.model.RawMetricData = {
    import RawMetricData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakermetrics.model.RawMetricData
      .builder()
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .optionallyWith(step.map(value => Step.unwrap(value): Integer))(_.step)
      .value(value: java.lang.Double)
      .build()
  }
  def asReadOnly: zio.aws.sagemakermetrics.model.RawMetricData.ReadOnly =
    zio.aws.sagemakermetrics.model.RawMetricData.wrap(buildAwsValue())
}
object RawMetricData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakermetrics.model.RawMetricData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakermetrics.model.RawMetricData =
      zio.aws.sagemakermetrics.model.RawMetricData(
        metricName,
        timestamp,
        step.map(value => value),
        value
      )
    def metricName: MetricName
    def timestamp: Timestamp
    def step: Optional[Step]
    def value: Double
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getStep: ZIO[Any, AwsError, Step] =
      AwsError.unwrapOptionField("step", step)
    def getValue: ZIO[Any, Nothing, Double] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakermetrics.model.RawMetricData
  ) extends zio.aws.sagemakermetrics.model.RawMetricData.ReadOnly {
    override val metricName: MetricName =
      zio.aws.sagemakermetrics.model.primitives.MetricName(impl.metricName())
    override val timestamp: Timestamp =
      zio.aws.sagemakermetrics.model.primitives.Timestamp(impl.timestamp())
    override val step: Optional[Step] = zio.aws.core.internal
      .optionalFromNullable(impl.step())
      .map(value => zio.aws.sagemakermetrics.model.primitives.Step(value))
    override val value: Double = impl.value(): Double
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakermetrics.model.RawMetricData
  ): zio.aws.sagemakermetrics.model.RawMetricData.ReadOnly = new Wrapper(impl)
}
