package zio.aws.sagemakermetrics
import zio.mock.{Proxy, Mock}
import zio.aws.sagemakermetrics.model.BatchPutMetricsRequest
import zio.aws.core.AwsError
import zio.aws.sagemakermetrics.model.BatchPutMetricsResponse.ReadOnly
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.sagemakermetrics.SageMakerMetricsAsyncClient
object SageMakerMetricsMock extends Mock[SageMakerMetrics] {
  object BatchPutMetrics
      extends Effect[BatchPutMetricsRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, SageMakerMetrics] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, SageMakerMetrics] { rts =>
        zio.ZIO.succeed {
          new SageMakerMetrics {
            val api: SageMakerMetricsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): SageMakerMetrics = this
            def batchPutMetrics(
                request: BatchPutMetricsRequest
            ): IO[AwsError, ReadOnly] = proxy(BatchPutMetrics, request)
          }
        }
      }
    }
  }
}
